/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.jms;

import com.ibm.ccl.sca.core.util.JavaUtil;
import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.IWebSphereValidationConstants;
import com.ibm.ccl.sca.java.core.model.ISCAJdtWrapper;
import com.ibm.ccl.sca.java.core.model.JavaResolverHelper;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;

public class WireFormatCustomObjectRule
extends AbstractValidationRule {
    public WireFormatCustomObjectRule() {
        super("com.ibm.ccl.sca.facets.websphere.WireFormatCustomObjectRule");
    }

    protected WireFormatCustomObjectRule(String id) {
        super(id);
    }

    public String getDescription() {
        return Messages.DESC_WIRE_FORMAT_CUSTOM_OBJECT_RULE;
    }

    public int getDefaultSeverity() {
        return 1;
    }

    protected String getInterface() {
        return "com.ibm.websphere.soa.sca.wireformat.WireFormatHandler";
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        StartElement element = (StartElement)context.getModel();
        String clazz = ValidationUtils.getAttribute((StartElement)element, (QName)IWebSphereValidationConstants.CLASS_ATTR);
        if (clazz == null || clazz.length() == 0) {
            return;
        }
        try {
            IType type;
            JavaResolverHelper resolver = new JavaResolverHelper(context.getResource().getProject());
            List artifacts = resolver.resolve(clazz, monitor);
            IStatus status = resolver.getStatus();
            if (!status.isOK()) {
                context.postMessage(status.getMessage(), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
                return;
            }
            ISCAJdtWrapper wrapper = (ISCAJdtWrapper)artifacts.get(0);
            if (wrapper.getResource() != null) {
                context.postResourceDependency(wrapper.getResource());
            }
            if (!JavaUtil.implementsInterface((IType)(type = (IType)wrapper.getModelObject()), (String)this.getInterface())) {
                context.postMessage(Messages.bind((String)Messages.MSG_WIRE_FORMAT_CUSTOM_OBJECT_RULE, (Object)clazz, (Object)this.getInterface()), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
            }
        }
        catch (CoreException e) {
            context.postMessage(e.getMessage(), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber(), 2);
        }
    }
}

