/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.jee;

import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.jee.JEEImplUtils;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class JEEProjectRule
extends AbstractValidationRule {
    private static final String APPLICATION_COMPOSITE = "application.composite";
    private static final String APP_SUFFIX = ".app";
    private static final String EJB_SUFFIX = ".ejb";
    private static final String WEB_SUFFIX = ".web";

    public JEEProjectRule() {
        super("com.ibm.ccl.sca.facets.websphere.JEEProjectRule");
    }

    public String getDescription() {
        return Messages.DESC_JEE_PROJECT_RULE;
    }

    public int getDefaultSeverity() {
        return 1;
    }

    private static boolean isJEEEARProject(IValidationContext context) {
        Boolean b = (Boolean)context.get("com.ibm.ccl.sca.facets.websphere.JEEProjectRule.app");
        if (b == null) {
            b = JEEImplUtils.isJEEEARProject(context.getResource().getProject());
            context.put("com.ibm.ccl.sca.facets.websphere.JEEProjectRule.app", (Object)b);
        }
        return b;
    }

    private static boolean isJEEEJBProject(IValidationContext context) {
        Boolean b = (Boolean)context.get("com.ibm.ccl.sca.facets.websphere.JEEProjectRule.ejb");
        if (b == null) {
            b = JEEImplUtils.isJEEEJBProject(context.getResource().getProject());
            context.put("com.ibm.ccl.sca.facets.websphere.JEEProjectRule.ejb", (Object)b);
        }
        return b;
    }

    private static boolean isJEEWebProject(IValidationContext context) {
        Boolean b = (Boolean)context.get("com.ibm.ccl.sca.facets.websphere.JEEProjectRule.web");
        if (b == null) {
            b = JEEImplUtils.isJEEWebProject(context.getResource().getProject());
            context.put("com.ibm.ccl.sca.facets.websphere.JEEProjectRule.web", (Object)b);
        }
        return b;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        IResource resource = context.getResource();
        boolean distinguished = JEEImplUtils.isDistinguishedLocation(resource);
        if (!distinguished) {
            return;
        }
        context.put(this.getID(), (Object)distinguished);
        StartElement element = (StartElement)context.getModel();
        if (APPLICATION_COMPOSITE.equals(resource.getName()) && !JEEProjectRule.isJEEEARProject(context)) {
            context.postMessage(Messages.MSG_JEE_PROJECT_RULE_EAR, "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
        }
    }

    static boolean isApplicationComposite(IValidationContext context) {
        return context.get("com.ibm.ccl.sca.facets.websphere.JEEProjectRule") != null && JEEProjectRule.isJEEEARProject(context);
    }

    static boolean isEJBJarComposite(IValidationContext context) {
        return context.get("com.ibm.ccl.sca.facets.websphere.JEEProjectRule") != null && JEEProjectRule.isJEEEJBProject(context);
    }

    static boolean isWebComposite(IValidationContext context) {
        return context.get("com.ibm.ccl.sca.facets.websphere.JEEProjectRule") != null && JEEProjectRule.isJEEWebProject(context);
    }
}

