/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.jee;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public class JEEImplUtils {
    public static boolean isDistinguishedLocation(IResource resource) {
        IProject project = resource.getProject();
        IVirtualFile file = null;
        if (JavaEEProjectUtilities.isEARProject((IProject)project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            file = component.getRootFolder().getFile((IPath)new Path("META-INF/application.composite"));
        } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            file = component.getRootFolder().getFile((IPath)new Path("META-INF/ejb-jar.composite"));
        } else if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)project);
            file = component.getRootFolder().getFile((IPath)new Path("WEB-INF/web.composite"));
        }
        return file != null && resource.equals((Object)file.getUnderlyingFile());
    }

    public static boolean isJEEEARProject(IProject project) {
        if (JavaEEProjectUtilities.isEARProject((IProject)project)) {
            String version = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
            return J2EEVersionUtil.convertVersionStringToInt((String)version) >= 50;
        }
        return false;
    }

    public static boolean isApplicationComposite(IResource resource) {
        return JEEImplUtils.isDistinguishedLocation(resource) && JEEImplUtils.isJEEEARProject(resource.getProject());
    }

    public static boolean isJEEEJBProject(IProject project) {
        if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            String version = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
            return J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID((String)version) >= 50;
        }
        return false;
    }

    public static boolean isEJBJarComposite(IResource resource) {
        return JEEImplUtils.isDistinguishedLocation(resource) && JEEImplUtils.isJEEEJBProject(resource.getProject());
    }

    public static boolean isJEEWebProject(IProject project) {
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            String version = JavaEEProjectUtilities.getJ2EEDDProjectVersion((IProject)project);
            return J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID((String)version) >= 50;
        }
        return false;
    }

    public static boolean isWebComposite(IResource resource) {
        return JEEImplUtils.isDistinguishedLocation(resource) && JEEImplUtils.isJEEWebProject(resource.getProject());
    }
}

