/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation.jee;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationConstants;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.facets.websphere.util.FacetsUtil;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.jee.JEEImplUtils;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;

public class ApplicationCompositeResolverRule
extends AbstractValidationRule {
    private boolean isContribution;

    public ApplicationCompositeResolverRule(boolean isContribution) {
        super("com.ibm.ccl.sca.facets.websphere.ApplicationCompositeResolverRule");
        this.isContribution = isContribution;
    }

    public String getDescription() {
        return Messages.DESC_APPLICATION_COMPOSITE_RESOLVER_RULE;
    }

    private QName getQName(StartElement element) {
        QName attr = this.isContribution ? IValidationConstants.COMPOSITE_ATTR : IValidationConstants.NAME_ATTR;
        return ValidationUtils.toQName((StartElement)element, (QName)attr);
    }

    private String getMessage() {
        return this.isContribution ? Messages.MSG_APPLICATION_COMPOSITE_RESOLVER_RULE_DEPLOY : Messages.MSG_APPLICATION_COMPOSITE_RESOLVER_RULE_IMPL;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        List artifacts = ValidationUtils.getResolvedArtifacts((IValidationContext)context);
        if (artifacts == null) {
            return;
        }
        StartElement element = (StartElement)context.getModel();
        QName name = this.getQName(element);
        if (name == null) {
            return;
        }
        for (ISCAArtifact artifact : artifacts) {
            ISCAComposite composite;
            if (!(artifact instanceof ISCAComposite) || !name.equals((composite = (ISCAComposite)artifact).getName())) continue;
            IResource resource = composite.getResource();
            IProject project = resource.getProject();
            if (!FacetsUtil.isProjWAS101(project) || !JEEImplUtils.isDistinguishedLocation(resource) || !JEEImplUtils.isJEEWebProject(project) && !JEEImplUtils.isJEEEJBProject(project) && !JEEImplUtils.isJEEEARProject(project)) break;
            context.postMessage(Messages.bind((String)this.getMessage(), (Object)name), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
            break;
        }
    }
}

