/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation;

import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.facets.websphere.util.FacetsUtil;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import com.ibm.ccl.sca.internal.facets.websphere.validation.IWebSphereValidationConstants;
import javax.xml.namespace.QName;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class SDORule
extends AbstractValidationRule {
    private static final String DATA_OBJECT = "commonj.sdo.DataObject";
    private static final String SDO_STAR = "commonj.sdo.*";

    public SDORule() {
        super("com.ibm.ccl.sca.facets.websphere.SDORule");
    }

    public String getDescription() {
        return Messages.DESC_SDO_RULE;
    }

    private String extractClass(StartElement element, QName attribute) {
        String clazz = ValidationUtils.getAttribute((StartElement)element, (QName)attribute);
        if (clazz == null || clazz.length() == 0) {
            return null;
        }
        return clazz;
    }

    private boolean isUsingSDO(String clazz, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit source;
        if (clazz == null) {
            return false;
        }
        IType type = project.findType(clazz, monitor);
        if (type == null) {
            return false;
        }
        if (!type.isBinary() && (source = type.getCompilationUnit()) != null && (source.getImport(DATA_OBJECT).exists() || source.getImport(SDO_STAR).exists())) {
            return true;
        }
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            String sig = method.getSignature().replace('/', '.');
            if (sig.indexOf(DATA_OBJECT) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void checkForSDO(IValidationContext context, StartElement element, IJavaProject project, boolean isImpl, IProgressMonitor monitor) throws JavaModelException {
        String clazz = null;
        if (isImpl) {
            clazz = this.extractClass(element, IWebSphereValidationConstants.CLASS_ATTR);
            if (this.isUsingSDO(clazz, project, monitor)) {
                context.postMessage(Messages.bind((String)Messages.MSG_SDO_RULE_CLASS, (Object)clazz), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
            }
        } else {
            clazz = this.extractClass(element, IWebSphereValidationConstants.INTERFACE_ATTR);
            if (this.isUsingSDO(clazz, project, monitor)) {
                context.postMessage(Messages.bind((String)Messages.MSG_SDO_RULE_INTERFACE, (Object)clazz), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
            }
            if (this.isUsingSDO(clazz = this.extractClass(element, IWebSphereValidationConstants.CALLBACK_INTERFACE_ATTR), project, monitor)) {
                context.postMessage(Messages.bind((String)Messages.MSG_SDO_RULE_INTERFACE, (Object)clazz), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
            }
        }
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        IProject project = context.getResource().getProject();
        if (!FacetsUtil.isProjWAS100(project)) {
            return;
        }
        StartElement element = (StartElement)context.getModel();
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return;
            }
            boolean isImpl = element.getName().getLocalPart().equals("implementation.java");
            this.checkForSDO(context, element, JavaCore.create((IProject)project), isImpl, monitor);
        }
        catch (CoreException e) {
            context.postMessage(e.getMessage(), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber(), 2);
        }
    }
}

