/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation;

import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import java.util.List;
import javax.xml.stream.events.StartElement;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.eclipse.core.runtime.IProgressMonitor;

public class PromoteServiceBindingRule
extends AbstractValidationRule {
    public PromoteServiceBindingRule() {
        super("com.ibm.ccl.sca.facets.websphere.PromoteServiceBindingRule");
    }

    public String getDescription() {
        return Messages.DESC_PROMOTE_SERVICE_BINDING_RULE;
    }

    public int getDefaultSeverity() {
        return 1;
    }

    protected Contract getComponentContract(IValidationContext context, String promote) {
        return ValidationUtils.getComponentService((IValidationContext)context, (String)promote);
    }

    private boolean hasUnsupportedBinding(List<Binding> bindings) {
        for (Binding binding : bindings) {
            if (binding instanceof SCABinding) continue;
            return true;
        }
        return false;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        if (ValidationUtils.getComponentContainer((IValidationContext)context) != null) {
            return;
        }
        StartElement element = (StartElement)context.getModel();
        String[] promotes = ValidationUtils.getPromotes((StartElement)element);
        if (promotes != null) {
            String[] stringArray = promotes;
            int n = promotes.length;
            int n2 = 0;
            while (n2 < n) {
                String promote = stringArray[n2];
                Contract contract = this.getComponentContract(context, promote);
                if (contract != null && this.hasUnsupportedBinding(contract.getBindings())) {
                    context.postMessage(this.getMessage(), "com.ibm.ccl.sca.core.SCAProblemMarker", element.getLocation().getLineNumber());
                }
                ++n2;
            }
        }
    }

    protected String getMessage() {
        return Messages.MSG_PROMOTE_SERVICE_BINDING_RULE;
    }
}

