/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.facets.websphere.validation;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.SCAModelResolver;
import com.ibm.ccl.sca.core.validation.AbstractValidationRule;
import com.ibm.ccl.sca.core.validation.IValidationContext;
import com.ibm.ccl.sca.core.validation.ValidationUtils;
import com.ibm.ccl.sca.internal.facets.websphere.messages.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.StartElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetVersionRule
extends AbstractValidationRule {
    private static final IProjectFacet SCA_FACET = ProjectFacetsManager.getProjectFacet((String)"com.ibm.websphere.scafp");

    public FacetVersionRule() {
        super("com.ibm.ccl.sca.facets.websphere.FacetVersionRule");
    }

    public String getDescription() {
        return Messages.DESC_FACET_VERSION_RULE;
    }

    private IProjectFacetVersion getFacetVersion(IProject project) {
        IFacetedProject fProject;
        block3: {
            try {
                fProject = ProjectFacetsManager.create((IProject)project);
                if (fProject != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return fProject.getProjectFacetVersion(SCA_FACET);
    }

    public String[] getRuleDependencies(IValidationContext context) {
        return new String[]{"com.ibm.ccl.sca.core.ResolverRule"};
    }

    private boolean checkVersion(ISCAArtifact<?> artifact, IProjectFacetVersion version, List<IProject> alreadyCheckedProjects) {
        IProject project;
        IResource resource = artifact.getResource();
        IProject iProject = project = resource == null ? artifact.getParent() : resource.getProject();
        if (!alreadyCheckedProjects.contains(project)) {
            IProjectFacetVersion compareVersion = this.getFacetVersion(project);
            if (compareVersion == null || compareVersion.compareTo((Object)version) <= 0) {
                alreadyCheckedProjects.add(project);
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean checkVersion(ISCAArtifact<?> artifact, IProjectFacetVersion version, List<IProject> alreadyCheckedProjects, IProgressMonitor monitor) throws CoreException {
        if (!this.checkVersion(artifact, version, alreadyCheckedProjects)) {
            return false;
        }
        if (artifact instanceof ISCAComposite) {
            ISCAComposite composite = (ISCAComposite)artifact;
            SCAModelResolver resolver = new SCAModelResolver(composite);
            resolver.run(monitor);
            for (ISCAArtifact resolved : resolver.getArtifacts()) {
                if (this.checkVersion(resolved, version, alreadyCheckedProjects)) continue;
                return false;
            }
        }
        return true;
    }

    public void run(IValidationContext context, IProgressMonitor monitor) {
        List artifacts = ValidationUtils.getResolvedArtifacts((IValidationContext)context);
        if (artifacts == null || artifacts.isEmpty()) {
            return;
        }
        IProject project = context.getResource().getProject();
        IProjectFacetVersion version = this.getFacetVersion(project);
        if (version == null) {
            return;
        }
        ArrayList<IProject> alreadyCheckedProjects = new ArrayList<IProject>();
        alreadyCheckedProjects.add(project);
        try {
            for (ISCAArtifact artifact : artifacts) {
                if (this.checkVersion(artifact, version, alreadyCheckedProjects, monitor)) continue;
                context.postMessage(Messages.bind((String)Messages.MSG_FACET_VERSION_RULE, (Object)version.getVersionString()), "com.ibm.ccl.sca.core.SCAProblemMarker", ((StartElement)context.getModel()).getLocation().getLineNumber());
                return;
            }
            context.put(this.getID(), alreadyCheckedProjects);
        }
        catch (CoreException e) {
            context.postMessage(e.getMessage(), "com.ibm.ccl.sca.core.SCAProblemMarker", ((StartElement)context.getModel()).getLocation().getLineNumber(), 2);
        }
    }

    public static List<IProject> getProjects(IValidationContext context) {
        return (List)context.get("com.ibm.ccl.sca.facets.websphere.FacetVersionRule");
    }
}

