/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.wizards.contribution;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.tracing.LogWriter;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.creation.ui.wizards.contribution.ContributionCreationPage;
import com.ibm.ccl.sca.tuscany.TuscanyModelHelper;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Contribution;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;

public class NewContributionWizard
extends Wizard
implements INewWizard {
    private static final String NEWCONTRIBUTION_WIZARD_GIF = "icons/newcontribution.gif";
    private static final String META_INF_FOLDER = "META-INF";
    private ContributionCreationPage newContributionPage;
    private IStructuredSelection selection_;
    private Composite composite_ = null;
    private String SCA_CONTRIBUTION_XML = "sca-contribution.xml";
    private LogWriter logger = new LogWriter();

    public NewContributionWizard() {
        Bundle bundle = Platform.getBundle((String)"com.ibm.ccl.sca.creation.ui");
        URL url = bundle.getEntry(NEWCONTRIBUTION_WIZARD_GIF);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)url));
        this.setWindowTitle(Messages.TITLE_NEW_CONTRIBUTION_WIZARD);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        final TuscanyModelHelper modelHelper = TuscanyModelHelper.getInstance();
        IProject project = this.newContributionPage.getProject();
        if (project == null) {
            return false;
        }
        List<ISCAComposite> composites = this.newContributionPage.getDeployableComposites();
        final Contribution contribution = modelHelper.createContribution();
        String compositeName = null;
        try {
            for (ISCAComposite composite : composites) {
                compositeName = composite.getName().toString();
                contribution.getDeployables().add((Composite)composite.getModelObject());
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "com.ibm.ccl.sca.creation.ui", 0, Messages.bind((String)Messages.NewContributionWizard_4, compositeName), (Throwable)e);
            this.logger.write((Plugin)Activator.getDefault(), (IStatus)status);
        }
        final IFolder folder = project.getFolder(META_INF_FOLDER);
        final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation((ISchedulingRule)project){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask("", 4);
                    IStatus status = modelHelper.writeContributionToFile((IContainer)folder, NewContributionWizard.this.SCA_CONTRIBUTION_XML, contribution);
                    if (status.getSeverity() == 4) {
                        throw new CoreException(status);
                    }
                    monitor.worked(3);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    folder.refreshLocal(1, monitor);
                    final IFile contributionFile = folder.getFile(NewContributionWizard.this.SCA_CONTRIBUTION_XML);
                    monitor.subTask(Messages.bind((String)Messages.MSG_OPENING_EDITOR, (Object)contributionFile.getName()));
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                IDE.openEditor((IWorkbenchPage)page, (IFile)contributionFile, (boolean)true);
                            }
                            catch (PartInitException e) {
                                Status errStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_COMPOSITE_EDITOR_INIT, (Throwable)e);
                                NewContributionWizard.this.logger.write((Plugin)Activator.getDefault(), (IStatus)errStatus);
                                Shell topShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                MessageDialog warning = new MessageDialog(topShell, Messages.LABEL_TITLE_WARNING_DIALOG_CANNOT_OPEN_EDITOR_NewCompositeWizard, null, Messages.bind((String)Messages.NewContributionWizard_ERROR_OPENING_CONTRIBUTION_EDITOR, (Object)contributionFile.getName()), 0, new String[]{Messages.LABEL_WARNING_DIALOG_OK}, 0);
                                warning.open();
                            }
                        }
                    });
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.logger.write((Plugin)Activator.getDefault(), 4, (Throwable)e);
        }
        catch (InterruptedException e) {
            this.logger.write((Plugin)Activator.getDefault(), 8, (Throwable)e);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection_ = selection;
    }

    public void addPages() {
        this.newContributionPage = new ContributionCreationPage(Messages.PAGE_NAME_NEWCONTRIBUTION, this.selection_);
        this.newContributionPage.setTitle(Messages.PAGE_TITLE_NEWCONTRIBUTION);
        this.newContributionPage.setDescription(Messages.PAGE_DESC_NEWCONTRIBUTION);
        this.addPage((IWizardPage)this.newContributionPage);
    }

    public QName getComposite() {
        if (this.composite_ == null) {
            return null;
        }
        return this.composite_.getName();
    }
}

