/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.wizards.contribution;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.ui.common.controls.AbstractSelectionListener;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionControl;
import com.ibm.ccl.sca.internal.ui.common.controls.IPackButtonAction;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.internal.ui.project.SCAProjectWizard;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class ContributionCreationPage
extends WizardPage {
    private static final String CONTRIBUTION_FILENAME = "sca-contribution.xml";
    private String INFOPOP_NEWCONTRIBUTION_CREATION = "NEWCONTRIBUTION_CREATION";
    private Combo projectCombo_;
    private Button newSCAProjectButton_;
    private Text outputLocationText_;
    private ICompositeSelectionControl compositeSelectionControl;
    List<ISCAProject> scaProjects_;
    private IStructuredSelection selection_;

    public ContributionCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection_ = selection;
    }

    public void createControl(Composite parent) {
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.creation.ui");
        Composite pageui = uiUtils.createComposite(parent, 3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageui, "com.ibm.ccl.sca.ui." + this.INFOPOP_NEWCONTRIBUTION_CREATION);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)pageui);
        Dialog.applyDialogFont((Control)pageui);
        this.projectCombo_ = uiUtils.createCombo(pageui, Messages.LABEL_NEWCONTRIBUTION_PROJECT, Messages.TOOLTIP_NEWCONTRIBUTION_PROJECT, null, 2056);
        this.newSCAProjectButton_ = uiUtils.createPushButton(pageui, Messages.LABEL_NEWCONTRIBUTION_NEW_PROJECT, Messages.TOOLTIP_NEWCONTRIBUTION_NEW_PROJECT, null);
        this.outputLocationText_ = uiUtils.createText(pageui, Messages.LABEL_NEWCONTRIBUTION_OUTPUT_LOCATION, Messages.TOOLTIP_NEWCONTRIBUTION_OUTPUT_LOCATION, null, 2056);
        new Label(pageui, 0);
        this.projectCombo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = ContributionCreationPage.this.projectCombo_.getSelectionIndex();
                IProject selectedProj = ContributionCreationPage.this.scaProjects_.get(i).getProject();
                ContributionCreationPage.this.compositeSelectionControl.setCurrentResource((IResource)selectedProj);
                ContributionCreationPage.this.outputLocationText_.setText(String.valueOf(selectedProj.getFullPath().toString()) + "/META-INF");
                ContributionCreationPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.newSCAProjectButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SCAProjectWizard wizard = new SCAProjectWizard();
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                dialog.open();
                try {
                    ContributionCreationPage.this.scaProjects_ = SCAModelUtil.getSCAProjectsList();
                }
                catch (CoreException modelException) {
                    Status errStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CANNOT_GET_SCA_PROJECTS_FROM_METAMODEL, (Throwable)modelException);
                    Activator.getDefault().getLog().log((IStatus)errStatus);
                }
                ContributionCreationPage.this.populateProject(wizard.getSCAProject(), false);
                ContributionCreationPage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setButtonLayoutData(this.newSCAProjectButton_);
        GridData gridData = new GridData(1808);
        Label compositesLabel = new Label(pageui, 16384);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 20;
        compositesLabel.setLayoutData((Object)gridData);
        compositesLabel.setText(Messages.LABEL_NEWCONTRIBUTION_DEPLOYABLE_COMPOSITE);
        compositesLabel.setToolTipText(Messages.TOOLTIP_NEWCONTRIBUTION_DEPLOYABLE_COMPOSITE);
        Composite selection = uiUtils.createComposite(pageui, 1);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 3;
        selection.setLayoutData((Object)gridData);
        this.initializeControls();
        this.compositeSelectionControl = CompositeSelectionControlFactory.createCompositeSelectionControlAsCheckedTree((Composite)selection);
        this.compositeSelectionControl.setCurrentResource((IResource)this.getProject());
        this.compositeSelectionControl.initialize();
        this.compositeSelectionControl.packButtons(new IPackButtonAction(){

            public void pack(Button b) {
                ContributionCreationPage.this.setButtonLayoutData(b);
            }
        });
        this.compositeSelectionControl.addListenerObject((Object)new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ContributionCreationPage.this.validate();
            }
        });
        this.compositeSelectionControl.addSelectionListener2SelectAll(new AbstractSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContributionCreationPage.this.validate();
            }
        });
        this.compositeSelectionControl.addSelectionListener2DeselectAll(new AbstractSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContributionCreationPage.this.validate();
            }
        });
        this.compositeSelectionControl.addSearchScopeListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributionCreationPage.this.validate();
            }
        });
        this.initializeFromSelection();
    }

    private void initializeControls() {
        try {
            IProject initialProject = null;
            if (this.selection_ == null) {
                initialProject = null;
            } else if (this.selection_ instanceof TreeSelection) {
                Object element = ((TreeSelection)this.selection_).getFirstElement();
                if (element instanceof ICompilationUnit) {
                    ICompilationUnit icu = (ICompilationUnit)element;
                    IType javaType = icu.getTypes()[0];
                    initialProject = javaType.getJavaProject().getProject();
                } else if (element instanceof IFile) {
                    IFile file = (IFile)element;
                    initialProject = file.getProject();
                } else if (element instanceof ISCANode) {
                    ISCANode node = (ISCANode)element;
                    initialProject = node.getProject();
                } else if (element instanceof ISCAArtifact) {
                    ISCAArtifact artifact = (ISCAArtifact)element;
                    initialProject = artifact.getParent();
                } else if (element instanceof IProject) {
                    initialProject = (IProject)element;
                }
            } else {
                Object element = this.selection_.getFirstElement();
                if (element instanceof IProject) {
                    initialProject = (IProject)element;
                }
            }
            this.scaProjects_ = SCAModelUtil.getSCAProjectsList();
            this.populateProject(initialProject, true);
        }
        catch (CoreException e) {
            Status errStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.MSG_ERROR_INITIALIZE_COMPOSITE_WIZARD, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errStatus);
        }
    }

    private void populateProject(IProject project, boolean isInitialSelection) {
        if (project == null && !isInitialSelection) {
            return;
        }
        int i = 0;
        int selectionIndex = 0;
        boolean selectionIsSCAProject = false;
        this.projectCombo_.removeAll();
        for (ISCAProject scaProject : this.scaProjects_) {
            String projectName = scaProject.getProject().getName();
            this.projectCombo_.add(projectName);
            if (project != null && projectName.equals(project.getName())) {
                selectionIndex = i;
                selectionIsSCAProject = true;
            }
            ++i;
        }
        if (!selectionIsSCAProject) {
            return;
        }
        if (project != null) {
            this.outputLocationText_.setText(String.valueOf(project.getFullPath().toString()) + "/META-INF");
            this.projectCombo_.select(selectionIndex);
            if (this.compositeSelectionControl != null) {
                this.compositeSelectionControl.setCurrentResource((IResource)project);
            }
        }
    }

    private void initializeFromSelection() {
        if (this.selection_ == null) {
            return;
        }
        for (Object selected : this.selection_) {
            if (selected instanceof NamespaceNode) {
                Object[] children;
                Object[] objectArray = children = ((NamespaceNode)selected).getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    IResource resource = ((ISCAComposite)child).getResource();
                    this.compositeSelectionControl.select((Object)resource);
                    ++n2;
                }
                continue;
            }
            if (selected instanceof ISCAComposite) {
                IResource resource = ((ISCAComposite)selected).getResource();
                this.compositeSelectionControl.select((Object)resource);
                continue;
            }
            if (!(selected instanceof IFile)) continue;
            this.compositeSelectionControl.select(selected);
        }
        this.validate();
    }

    public IProject getProject() {
        int i = this.projectCombo_.getSelectionIndex();
        if (this.scaProjects_.size() == 0 || i == -1 || i > this.scaProjects_.size()) {
            return null;
        }
        return this.scaProjects_.get(i).getProject();
    }

    public String getOutputLocation() {
        return this.outputLocationText_.getText();
    }

    public List<ISCAComposite> getDeployableComposites() {
        return this.compositeSelectionControl.getSelectedComposites();
    }

    private Set<IProject> getProjectSet(IProject project) {
        HashSet<IProject> projectSet = new HashSet<IProject>();
        projectSet.add(project);
        if (project.isAccessible()) {
            try {
                IProject[] iProjectArray = project.getReferencedProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject referencedProject = iProjectArray[n2];
                    projectSet.add(referencedProject);
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        return projectSet;
    }

    private void validate() {
        String path = this.outputLocationText_.getText();
        if (path == null || path.trim().length() == 0) {
            this.setErrorMessage(null);
            this.setMessage(null);
            this.setPageComplete(false);
            return;
        }
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(path));
        if (folder.getFile(CONTRIBUTION_FILENAME).exists()) {
            this.setErrorMessage(Messages.ERROR_CONTRIBUTION_EXISTS);
            this.setMessage(null);
            this.setPageComplete(false);
            return;
        }
        ArrayList<QName> seenQNames = new ArrayList<QName>();
        IProject project = this.getProject();
        Set<IProject> projectSet = this.getProjectSet(project);
        boolean hasSelectedOutsideProjectSet = false;
        for (ISCAComposite composite : this.compositeSelectionControl.getSelectedComposites()) {
            if (seenQNames.contains(composite.getName())) {
                this.setErrorMessage(com.ibm.ccl.sca.ui.messages.Messages.ERROR_DUP_QNAME);
                this.setMessage(null);
                this.setPageComplete(false);
                return;
            }
            seenQNames.add(composite.getName());
            if (projectSet.contains(composite.getParent())) continue;
            hasSelectedOutsideProjectSet = true;
        }
        if (hasSelectedOutsideProjectSet) {
            this.setErrorMessage(null);
            this.setMessage(Messages.bind((String)com.ibm.ccl.sca.ui.messages.Messages.WARN_NOT_IN_DEPENDENT_PROJECT, (Object)project.getName()), 2);
            this.setPageComplete(true);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

