/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.wizards;

import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.extension.ICompositeWizardExtension;
import com.ibm.ccl.sca.internal.ui.navigator.node.ComponentNode;
import com.ibm.ccl.sca.internal.ui.navigator.node.NamespaceNode;
import com.ibm.ccl.sca.ui.navigator.ISCANode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;

public class RegularSCAComposite
implements ICompositeWizardExtension {
    @Override
    public String getCompositeNameDefault(IProject project, IStructuredSelection selection) {
        return "";
    }

    @Override
    public boolean getCompositeNameEnabled() {
        return true;
    }

    @Override
    public IProject getDefaultProject(IStructuredSelection selection) {
        Object element;
        IProject initialProject = null;
        if (selection instanceof TreeSelection) {
            Object element2 = ((TreeSelection)selection).getFirstElement();
            if (element2 instanceof ICompilationUnit) {
                ICompilationUnit icu = (ICompilationUnit)element2;
                IType javaType = null;
                try {
                    javaType = icu.getTypes()[0];
                }
                catch (Exception exc) {
                    Activator.traceError(exc);
                }
                if (javaType != null) {
                    initialProject = javaType.getJavaProject().getProject();
                }
            } else if (element2 instanceof IFile) {
                IFile file = (IFile)element2;
                initialProject = file.getProject();
            } else if (element2 instanceof ISCANode) {
                ISCANode node = (ISCANode)element2;
                initialProject = node.getProject();
            } else if (element2 instanceof ISCAArtifact) {
                ISCAArtifact artifact = (ISCAArtifact)element2;
                initialProject = artifact.getParent();
            } else if (element2 instanceof IProject) {
                initialProject = (IProject)element2;
            }
        } else if (selection != null && (element = selection.getFirstElement()) instanceof IProject) {
            initialProject = (IProject)element;
        }
        return initialProject;
    }

    @Override
    public String getPath(IProject project, String compositeName, String oldPathString) {
        String defaultFolder = SCAToolsCorePlugin.getInstance().getPreferences().getDefaultProjectFolder(project);
        Path oldPath = new Path(oldPathString);
        String oldProjectName = null;
        IPath oldFolder = null;
        Path newFolder = null;
        IPath newPath = project.getFullPath();
        if (oldPath.isValidPath(oldPathString)) {
            String[] segments = oldPath.segments();
            if (segments.length > 0) {
                oldProjectName = segments[0];
            }
            if (segments.length >= 2) {
                oldFolder = new Path("").append((IPath)oldPath);
                String extension = (oldFolder = oldFolder.removeFirstSegments(1)).getFileExtension();
                if (extension != null && !extension.isEmpty()) {
                    oldFolder = oldFolder.removeLastSegments(1);
                }
            }
        }
        if (oldProjectName == null || !oldProjectName.equals(project.getName())) {
            newFolder = new Path(defaultFolder);
            if (!newFolder.isValidPath(defaultFolder)) {
                newFolder = null;
            }
        } else {
            newFolder = oldFolder;
        }
        if (newFolder != null) {
            newPath = newPath.append((IPath)newFolder);
        }
        if (!compositeName.trim().isEmpty()) {
            newPath = newPath.append(compositeName);
            newPath = newPath.addFileExtension("composite");
        }
        return newPath.toString();
    }

    @Override
    public boolean getPathEnabled() {
        return true;
    }

    @Override
    public String getNamespaceDefault(IProject project, IStructuredSelection selection) {
        String defaultNamespace = null;
        if (selection instanceof TreeSelection) {
            Object element = ((TreeSelection)selection).getFirstElement();
            if (element instanceof IFile) {
                ISCAComposite composite;
                IFile file = (IFile)element;
                if (file.getFileExtension().equals("composite") && (composite = (ISCAComposite)file.getAdapter(ISCAArtifact.class)) != null) {
                    defaultNamespace = composite.getName().getNamespaceURI();
                }
            } else if (element instanceof ISCANode) {
                ISCANode node = (ISCANode)element;
                if (node instanceof NamespaceNode) {
                    defaultNamespace = ((NamespaceNode)node).getNamespace();
                } else if (node instanceof ComponentNode) {
                    ISCAComposite composite = (ISCAComposite)node.getParent();
                    defaultNamespace = composite.getName().getNamespaceURI();
                }
            } else if (element instanceof ISCAArtifact && element instanceof ISCAComposite) {
                defaultNamespace = ((ISCAComposite)element).getName().getNamespaceURI();
            }
        }
        if (defaultNamespace == null) {
            defaultNamespace = SCAToolsCorePlugin.getInstance().getPreferences().getNamespace(project);
        }
        return defaultNamespace;
    }

    @Override
    public boolean getNamespaceEnabled() {
        return true;
    }

    @Override
    public IStatus validate(String location, String compositeName, String namespace) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus validateProject(IProject project) {
        return Status.OK_STATUS;
    }

    @Override
    public boolean canCreateNewProjects() {
        return true;
    }
}

