/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.wizards;

import com.ibm.ccl.sca.core.model.ISCAProject;
import com.ibm.ccl.sca.core.model.SCAModelUtil;
import com.ibm.ccl.sca.core.util.QNameHelpers;
import com.ibm.ccl.sca.core.util.intents.IntentUtils;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.creation.ui.wizards.registry.CompositeWizardDescriptor;
import com.ibm.ccl.sca.internal.creation.ui.wizards.registry.CompositeWizardRegistry;
import com.ibm.ccl.sca.internal.ui.common.controls.intents.IntentSelectionDialog;
import com.ibm.ccl.sca.internal.ui.project.SCAProjectWizard;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CompositeCreationPage
extends WizardPage {
    private String INFOPOP_NEWCOMPOSITE_CREATION = "NEWCOMPOSITE_CREATION";
    private Combo kindCombo_;
    private Combo projectCombo_;
    private Text pathCombo_;
    private Text compositeNameText_;
    private Text namespaceText_;
    private Button autoWireButton_;
    private IStructuredSelection selection_;
    private Button newSCAProjectButton_;
    private Listener listener_;
    private List<QName> intents_;
    private Table requiresTable_;
    private IProject target_;
    private final String INTENT_QNAME = "INTENT_QNAME";
    private List<CompositeWizardDescriptor> descriptors;
    private SelectionListener kindListener = null;
    private SelectionListener projectListener = null;
    private ModifyListener pathListener = null;
    private ModifyListener compositeNameListener = null;
    private ModifyListener namespaceListener = null;
    private boolean suppressInitialErrorMessage;

    public CompositeCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection_ = selection;
        this.setPageComplete(false);
        this.intents_ = new ArrayList<QName>();
        this.descriptors = CompositeWizardRegistry.getInstance().getWizardKinds();
    }

    public void createControl(Composite parent) {
        this.suppressInitialErrorMessage = true;
        UIUtils uiUtils = new UIUtils("com.ibm.ccl.sca.ui");
        Composite pageui = uiUtils.createComposite(parent, 3);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageui, "com.ibm.ccl.sca.creation.ui." + this.INFOPOP_NEWCOMPOSITE_CREATION);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)pageui);
        this.kindCombo_ = uiUtils.createCombo(pageui, Messages.CompositeCreationPage_2, Messages.CompositeCreationPage_6, null, 2056);
        this.kindListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeCreationPage.this.handleKindChanged();
            }
        };
        this.kindCombo_.addSelectionListener(this.kindListener);
        new Label(pageui, 0);
        this.projectCombo_ = uiUtils.createCombo(pageui, Messages.LABEL_NEWCOMPOSITE_PROJECT, Messages.TOOLTIP_NEWCOMPOSITE_PROJECT, null, 2056);
        this.newSCAProjectButton_ = uiUtils.createPushButton(pageui, Messages.LABEL_NEWCOMPOSITE_NEW_PROJECT, Messages.TOOLTIP_NEWCOMPOSITE_NEW_PROJECT, null);
        this.projectListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = CompositeCreationPage.this.projectCombo_.getSelectionIndex();
                List projects = (List)CompositeCreationPage.this.projectCombo_.getData("projects");
                IProject selectedProj = ((IProject)projects.get(i)).getProject();
                CompositeCreationPage.this.setTextFields();
                CompositeCreationPage.this.updateRequires(selectedProj);
                CompositeCreationPage.this.checkComplete();
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }
        };
        this.newSCAProjectButton_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SCAProjectWizard wizard = new SCAProjectWizard();
                IWorkbench workbench = PlatformUI.getWorkbench();
                wizard.init(workbench, null);
                Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                int returnCode = dialog.open();
                if (returnCode == 1) {
                    return;
                }
                IProject newSCAProject = wizard.getSCAProject();
                if (newSCAProject == null) {
                    return;
                }
                CompositeCreationPage.this.setKindToDefault();
                CompositeCreationPage.this.populateProjectCombo(newSCAProject);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.compositeNameText_ = uiUtils.createText(pageui, Messages.LABEL_NEWCOMPOSITE_COMPOSITE_NAME, Messages.TOOLTIP_NEWCOMPOSITE_COMPOSITE_NAME, null, 2048);
        new Label(pageui, 0);
        this.compositeNameText_.setFocus();
        this.compositeNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String oldPath = CompositeCreationPage.this.pathCombo_.getText();
                CompositeWizardDescriptor descriptor = CompositeCreationPage.this.getCurrentDescriptor();
                IProject project = CompositeCreationPage.this.getProject();
                String compName = CompositeCreationPage.this.getCompositeName();
                CompositeCreationPage.this.pathCombo_.setText(project == null ? "" : descriptor.getPath(project, compName, oldPath));
                CompositeCreationPage.this.checkComplete();
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }
        };
        this.namespaceText_ = uiUtils.createText(pageui, Messages.LABEL_NEWCOMPOSITE_TARGET_NAMESPACE, Messages.TOOLTIP_NEWCOMPOSITE_TARGET_NAMESPACE, null, 2048);
        new Label(pageui, 0);
        this.namespaceListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeCreationPage.this.checkComplete();
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }
        };
        this.pathCombo_ = uiUtils.createText(pageui, Messages.LABEL_NEWCOMPOSITE_OUTPUT_LOCATION, Messages.TOOLTIP_NEWCOMPOSITE_OUTPUT_LOCATION, null, 2048);
        this.pathListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompositeCreationPage.this.checkComplete();
                if (CompositeCreationPage.this.listener_ != null) {
                    CompositeCreationPage.this.listener_.handleEvent(null);
                }
            }
        };
        new Label(pageui, 0);
        Label advancedSettingsSeparator = new Label(pageui, 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        griddata.verticalIndent = 12;
        advancedSettingsSeparator.setLayoutData((Object)griddata);
        Composite composite2 = uiUtils.createComposite(pageui, 2);
        griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        composite2.setLayoutData((Object)griddata);
        this.autoWireButton_ = uiUtils.createCheckbox(composite2, Messages.LABEL_NEWCOMPOSITE_AUTOWIRE, Messages.TOOLTIP_NEWCOMPOSITE_AUTOWIRE, null);
        griddata = new GridData(256);
        griddata.horizontalSpan = 3;
        this.autoWireButton_.setLayoutData((Object)griddata);
        Composite intentComposite = uiUtils.createComposite(pageui, 2);
        griddata = new GridData(1808);
        griddata.horizontalSpan = 3;
        intentComposite.setLayoutData((Object)griddata);
        uiUtils.createLabel(intentComposite, Messages.LABEL_NEWCOMPOSITE_REQUIRES, null, 0);
        new Label(intentComposite, 0);
        this.requiresTable_ = uiUtils.createTable(intentComposite, Messages.TOOLTIP_NEWCOMPOSITE_REQUIRES, null, 2048);
        griddata = new GridData(1808);
        this.requiresTable_.setLayoutData((Object)griddata);
        Composite buttonComposite = new Composite(intentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(2));
        Button addIntents = uiUtils.createPushButton(buttonComposite, Messages.CompositeCreationPage_BUTTON_ADD, null, null);
        addIntents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List intentsNames = IntentUtils.getInteractionNames();
                intentsNames.addAll(IntentUtils.getImplementationNames());
                List intentsToShow = IntentUtils.convertToQName((List)intentsNames);
                intentsToShow.removeAll(CompositeCreationPage.this.intents_);
                IntentSelectionDialog dialog = new IntentSelectionDialog(CompositeCreationPage.this.getShell(), intentsToShow);
                if (dialog.createAndOpen() == 0) {
                    List selectedIntents = dialog.getSelectedQNames();
                    CompositeCreationPage.this.addRequires(selectedIntents);
                }
            }
        });
        Button removeIntents = uiUtils.createPushButton(buttonComposite, Messages.CompositeCreationPage_BUTTON_REMOVE, null, null);
        removeIntents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeCreationPage.this.removeRequires();
            }
        });
        this.setButtonLayoutData(addIntents);
        this.setButtonLayoutData(removeIntents);
        this.initializeControls();
        Dialog.applyDialogFont((Control)pageui);
        this.suppressInitialErrorMessage = false;
    }

    private void enableListeners(boolean enable) {
        this.projectCombo_.removeSelectionListener(this.projectListener);
        this.namespaceText_.removeModifyListener(this.namespaceListener);
        this.pathCombo_.removeModifyListener(this.pathListener);
        this.compositeNameText_.removeModifyListener(this.compositeNameListener);
        if (enable) {
            this.projectCombo_.addSelectionListener(this.projectListener);
            this.namespaceText_.addModifyListener(this.namespaceListener);
            this.pathCombo_.addModifyListener(this.pathListener);
            this.compositeNameText_.addModifyListener(this.compositeNameListener);
        }
    }

    private void setKindToDefault() {
        this.kindCombo_.removeSelectionListener(this.kindListener);
        this.kindCombo_.removeAll();
        for (CompositeWizardDescriptor descriptor : this.descriptors) {
            this.kindCombo_.add(descriptor.getName());
        }
        this.kindCombo_.select(CompositeWizardRegistry.getInstance().getDefaultIndex());
        this.setDescription(this.getCurrentDescriptor().getDescription());
        this.kindCombo_.addSelectionListener(this.kindListener);
    }

    private void initializeControls() {
        IProject initialProject = null;
        this.setKindToDefault();
        if (this.target_ == null) {
            initialProject = this.getCurrentDescriptor().getDefaultProject(this.selection_);
        } else {
            initialProject = this.target_;
            this.projectCombo_.setEnabled(false);
            this.newSCAProjectButton_.setEnabled(false);
        }
        this.populateProjectCombo(initialProject);
        this.setRequires(IntentUtils.getDefaultIntentsForComposite((IProject)initialProject));
    }

    private void setTextFields() {
        IProject project = this.getProject();
        CompositeWizardDescriptor descriptor = this.getCurrentDescriptor();
        String compositeName = project == null ? "" : descriptor.getCompositeNameDefault(project, this.selection_);
        String compLocation = project == null ? "" : descriptor.getPath(project, compositeName, this.pathCombo_.getText());
        String compNamespace = project == null ? "" : descriptor.getNamespaceDefault(project, this.selection_);
        this.compositeNameText_.setEnabled(descriptor.getCompositeNameEnabled());
        this.pathCombo_.setEnabled(descriptor.getLocationEnabled());
        this.namespaceText_.setEnabled(descriptor.getNamespaceEnabled());
        this.newSCAProjectButton_.setEnabled(descriptor.canCreateNewProjects());
        this.compositeNameText_.setText(compositeName);
        this.pathCombo_.setText(compLocation);
        this.namespaceText_.setText(compNamespace);
        this.checkComplete();
    }

    private void updateRequires(IProject project) {
        this.setRequires(IntentUtils.getDefaultIntentsForComposite((IProject)project));
    }

    private void setRequires(List<QName> intents) {
        this.intents_ = intents;
        this.requiresTable_.removeAll();
        for (QName intent : this.intents_) {
            TableItem item = new TableItem(this.requiresTable_, 0);
            item.setText(intent.getLocalPart());
            item.setData("INTENT_QNAME", (Object)intent);
        }
    }

    private void addRequires(List<QName> intents) {
        for (QName intent : intents) {
            TableItem item = new TableItem(this.requiresTable_, 0);
            item.setText(intent.getLocalPart());
            item.setData("INTENT_QNAME", (Object)intent);
        }
        this.intents_.addAll(intents);
    }

    private void removeRequires() {
        ArrayList<QName> intents = new ArrayList<QName>();
        TableItem[] tableItemArray = this.requiresTable_.getSelection();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            QName intent = (QName)item.getData("INTENT_QNAME");
            intents.add(intent);
            this.requiresTable_.remove(this.requiresTable_.indexOf(item));
            ++n2;
        }
        this.intents_.removeAll(intents);
    }

    private void populateProjectCombo(IProject project) {
        int selectionIndex = -1;
        this.enableListeners(false);
        ArrayList scaProjects = null;
        CompositeWizardDescriptor descriptor = this.getCurrentDescriptor();
        ArrayList<IProject> projects = new ArrayList<IProject>();
        try {
            scaProjects = SCAModelUtil.getSCAProjectsList();
        }
        catch (CoreException exc) {
            Status errStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.MSG_ERROR_INITIALIZE_COMPOSITE_WIZARD, (Throwable)exc);
            Activator.getDefault().getLog().log((IStatus)errStatus);
            scaProjects = new ArrayList();
        }
        this.projectCombo_.removeAll();
        for (ISCAProject scaProject : scaProjects) {
            IProject proj = scaProject.getProject();
            String projectName = proj.getName();
            IStatus projOk = descriptor.validateProject(proj);
            if (projOk.getSeverity() == 4) continue;
            projects.add(proj);
            this.projectCombo_.add(projectName);
            if (project == null || !projectName.equals(project.getName())) continue;
            selectionIndex = projects.size() - 1;
        }
        this.projectCombo_.setData("projects", projects);
        if (selectionIndex == -1) {
            if (this.target_ != null) {
                this.projectCombo_.removeAll();
            } else if (this.projectCombo_.getItemCount() > 0) {
                selectionIndex = 0;
            }
        }
        if (selectionIndex != -1) {
            this.projectCombo_.select(selectionIndex);
        }
        this.setTextFields();
        this.enableListeners(true);
    }

    private CompositeWizardDescriptor getCurrentDescriptor() {
        return this.descriptors.get(this.kindCombo_.getSelectionIndex());
    }

    private void handleKindChanged() {
        CompositeWizardDescriptor descriptor = this.getCurrentDescriptor();
        IProject project = this.target_ == null ? descriptor.getDefaultProject(this.selection_) : this.target_;
        this.setDescription(this.getCurrentDescriptor().getDescription());
        this.populateProjectCombo(project);
    }

    public IProject getProject() {
        int index = this.projectCombo_.getSelectionIndex();
        if (index < 0) {
            return null;
        }
        List projects = (List)this.projectCombo_.getData("projects");
        return (IProject)projects.get(index);
    }

    public String getPath() {
        return this.pathCombo_.getText();
    }

    public String getCompositeName() {
        return this.compositeNameText_.getText();
    }

    public String getNamespace() {
        return this.namespaceText_.getText();
    }

    public boolean getLocal() {
        return false;
    }

    public boolean getAutoWire() {
        return this.autoWireButton_.getSelection();
    }

    public String getIntents() {
        return IntentUtils.convertQNameListToString(this.intents_);
    }

    public void setTargetProject(IProject target) {
        this.target_ = target;
        if (this.projectCombo_ != null) {
            this.populateProjectCombo(target);
        }
    }

    public void setName(QName name) {
        if (name == null) {
            return;
        }
        this.namespaceText_.setText(name.getNamespaceURI());
        this.compositeNameText_.setText(name.getLocalPart());
    }

    public void setIntents(List<QName> intents) {
        this.setRequires(intents);
    }

    private void checkComplete() {
        if (this.suppressInitialErrorMessage) {
            return;
        }
        IStatus status = this.determinePageComplete();
        if (this.determinePageComplete() == Status.OK_STATUS) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        }
    }

    public IStatus determinePageComplete() {
        IProject project = this.getProject();
        Status currentStatus = null;
        if (this.projectCombo_.getItemCount() == 0) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_7);
            return currentStatus;
        }
        if (project == null) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_0);
            return currentStatus;
        }
        String name = this.getCompositeName();
        if (name == null || name.trim().length() == 0) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_4);
            return currentStatus;
        }
        if (!QNameHelpers.isValidNCName((String)name)) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_ERROR_COMPOSITE_NAME_NOT_NCNAME);
            return currentStatus;
        }
        String namespace = this.getNamespace();
        if (namespace == null || namespace.trim().length() == 0) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_5);
            return currentStatus;
        }
        if (!QNameHelpers.isValidNamespace((String)namespace)) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_NAMESPACE_INVALID);
            return currentStatus;
        }
        name = String.valueOf(name.trim()) + ".composite";
        IStatus validNameStatus = ResourcesPlugin.getWorkspace().validateName(name, 1);
        if (validNameStatus.getSeverity() == 4) {
            currentStatus = validNameStatus;
            return currentStatus;
        }
        String location = this.getPath();
        if (location == null || location.trim().length() == 0) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_1);
            return currentStatus;
        }
        IStatus validatePathStatus = ResourcesPlugin.getWorkspace().validatePath(location, 1);
        if (validatePathStatus.getSeverity() == 4) {
            currentStatus = validatePathStatus;
            return currentStatus;
        }
        Path path = new Path(location);
        String projectName = path.segment(0);
        IProject projectForPath = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!projectForPath.exists()) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_3);
            return currentStatus;
        }
        Object container = null;
        IPath relPath = path.removeFirstSegments(1);
        String compName = path.lastSegment();
        container = relPath.segmentCount() == 1 ? projectForPath : projectForPath.getFolder(relPath.removeLastSegments(1));
        IFile composite = projectForPath.getFile(relPath);
        if (composite.exists()) {
            currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_10);
            return currentStatus;
        }
        if (!Workspace.caseSensitive) {
            try {
                IResource[] iResourceArray = container.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    if (resource.getName().equalsIgnoreCase(compName)) {
                        currentStatus = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.CompositeCreationPage_11);
                        return currentStatus;
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {}
        }
        currentStatus = Status.OK_STATUS;
        return currentStatus;
    }

    public void setListener(Listener listener) {
        this.listener_ = listener;
    }

    public IStatus getCurrentStatus() {
        return this.determinePageComplete();
    }
}

