/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.widgets;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.bean.NullObject;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.creation.core.bean.CommandFragmentBean;
import com.ibm.ccl.sca.creation.core.bean.Config;
import com.ibm.ccl.sca.creation.core.bean.Implementation;
import com.ibm.ccl.sca.creation.core.bean.NoService;
import com.ibm.ccl.sca.creation.core.bean.NullServiceInterface;
import com.ibm.ccl.sca.creation.core.bean.ServiceInterface;
import com.ibm.ccl.sca.creation.core.extension.store.AbstractNewComponentCommandFragmentsStore;
import com.ibm.ccl.sca.creation.core.plugin.SCACreationCorePlugin;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import com.ibm.ccl.sca.internal.creation.core.data.ComponentData;
import com.ibm.ccl.sca.internal.creation.ui.command.RecognitionException;
import com.ibm.ccl.sca.internal.creation.ui.command.RecognizeInterfaceCommand;
import com.ibm.ccl.sca.ui.util.LabelAndId;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.util.List;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ComponentImplConfigWidget
extends SimpleWidgetDataContributor {
    private String INFOPOP_COMPONENT_CONFIG_IMPLEMENTATION_TYPE = "NEWCOMPONENT_COMPONENT_CONFIG0012";
    private Combo implTypeCombo_;
    private IProject project_;
    private boolean isProjectSet_ = false;
    private boolean isComponentServiceSet_ = false;
    private ComponentData componentData_;
    private AbstractNewComponentCommandFragmentsStore store;
    List<ISCAComposite> projectCompositesList_;
    List<ISCAComposite> allCompositesList_ = null;
    SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
    private UIUtils uiUtils;
    private Button replaceImplDeclaration;
    private ComponentService componentService_;
    private IStatus noIntfError;
    private boolean hasImpl;

    public ComponentImplConfigWidget() {
        this.store = SCACreationCorePlugin.getNewComponentCommandFragmentsStore();
        this.store.newSession();
    }

    public WidgetDataEvents addControls(Composite parentComposite, Listener statusListener) {
        this.uiUtils = new UIUtils("com.ibm.ccl.sca.creation.ui");
        Composite parent = this.uiUtils.createComposite(parentComposite, 2);
        Shell shell = parent.getShell();
        this.createImplementationSection(statusListener, parent, shell);
        return this;
    }

    private void createImplementationSection(final Listener statusListener, Composite parent, Shell shell) {
        Label implTypeLabel = new Label(parent, 64);
        implTypeLabel.setText(Messages.LABEL_IMPLEMENTATION_TYPE);
        implTypeLabel.setToolTipText(Messages.TOOLTIP_IMPLEMENTATION_TYPE);
        GridData griddata = new GridData(256);
        implTypeLabel.setLayoutData((Object)griddata);
        griddata = new GridData(768);
        griddata.grabExcessHorizontalSpace = true;
        this.implTypeCombo_ = new Combo(parent, 8);
        this.implTypeCombo_.setLayoutData((Object)griddata);
        this.implTypeCombo_.setToolTipText(Messages.TOOLTIP_IMPLEMENTATION_TYPE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.implTypeCombo_, "com.ibm.ccl.sca.creation.ui." + this.INFOPOP_COMPONENT_CONFIG_IMPLEMENTATION_TYPE);
        this.implTypeCombo_.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                statusListener.handleEvent(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label separator = new Label(parent, 258);
        griddata = new GridData(768);
        griddata.horizontalSpan = 2;
        griddata.verticalIndent = 12;
        separator.setLayoutData((Object)griddata);
        this.replaceImplDeclaration = this.uiUtils.createCheckbox(parent, Messages.ComponentImplConfigWidget_REPLACE_IMPL, null, null);
        this.replaceImplDeclaration.setSelection(false);
        griddata = new GridData(256);
        griddata.horizontalSpan = 2;
        this.replaceImplDeclaration.setLayoutData((Object)griddata);
        this.replaceImplDeclaration.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                statusListener.handleEvent(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void populateImplTypes(Combo implTypeCombo) {
        List types = this.preferences.getEnabledImplTypes(this.project_);
        LabelAndId[] labelAndIds = null;
        String defaultId = this.preferences.getDefaultImplTypeID(this.project_);
        int defaultIndex = -1;
        labelAndIds = new LabelAndId[types.size()];
        int index = 0;
        while (index < labelAndIds.length) {
            labelAndIds[index] = new LabelAndId();
            labelAndIds[index].id = ((ImplTypeEntry)types.get(index)).getID();
            labelAndIds[index].label = ((ImplTypeEntry)types.get(index)).getName();
            ++index;
        }
        String selectedImplId = this.getSelectedImplType();
        boolean foundSelectedImplId = false;
        implTypeCombo.removeAll();
        int index2 = 0;
        while (index2 < labelAndIds.length) {
            LabelAndId labelAndId = labelAndIds[index2];
            implTypeCombo.add(labelAndId.label);
            if (labelAndId.id.equals(selectedImplId)) {
                defaultIndex = index2;
                foundSelectedImplId = true;
            }
            if (labelAndId.id.equals(defaultId) && !foundSelectedImplId) {
                defaultIndex = index2;
            }
            ++index2;
        }
        if (defaultIndex == -1) {
            defaultIndex = 0;
        }
        implTypeCombo.select(defaultIndex);
        implTypeCombo.setData((Object)labelAndIds);
    }

    public IStatus getStatus() {
        if (this.noIntfError != null) {
            return this.noIntfError;
        }
        Status status = null;
        if (this.hasImpl && !this.replaceImplDeclaration.getSelection()) {
            return new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ComponentImplConfigWidget_IMPL_ALREADY_EXIST);
        }
        CommandFragmentBean[] fragments = this.getCommandFragments();
        if (fragments == null || fragments.length == 0) {
            status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ComponentImplConfigWidget_0);
        }
        if (fragments != null && fragments.length > 1) {
            status = new Status(4, "com.ibm.ccl.sca.creation.ui", Messages.ERROR_MORE_THAN_ONE_POSSIBLE_PATH);
        }
        return status;
    }

    public String getSelectedImplType() {
        int index = this.implTypeCombo_.getSelectionIndex();
        LabelAndId[] labelAndIds = (LabelAndId[])this.implTypeCombo_.getData();
        if (index < 0) {
            return null;
        }
        return labelAndIds[index].id;
    }

    public void selectIntfOrImplCombo(Combo combo, String id) {
        LabelAndId[] labelAndIds = (LabelAndId[])combo.getData();
        if (id == null) {
            combo.select(0);
            return;
        }
        int sel = 0;
        int i = 0;
        while (i < labelAndIds.length) {
            if (labelAndIds[i].id.equals(id)) {
                sel = i;
                break;
            }
            ++i;
        }
        combo.select(sel);
    }

    public IProject getProject() {
        return this.project_;
    }

    public void setProject(IProject project_) {
        this.project_ = project_;
        this.isProjectSet_ = true;
        this.init();
    }

    public CommandFragmentBean getCommandFragment() {
        CommandFragmentBean[] fragments = this.getCommandFragments();
        assert (fragments.length == 1);
        return fragments[0];
    }

    private CommandFragmentBean[] getCommandFragments() {
        IDataBean intf = this.componentData_.getServiceInterface();
        Object serviceIntf = null;
        serviceIntf = intf instanceof NullObject ? (this.componentData_.getServiceName() == null ? new NoService(false) : new NullServiceInterface()) : new ServiceInterface(intf.getID(), Config.REUSE);
        String implID = this.getSelectedImplType();
        Implementation impl = new Implementation(implID, Config.CREATE);
        return this.store.getCommandFragments(serviceIntf, impl, true);
    }

    public ComponentData getComponentData() {
        this.componentData_.setImplementation(null);
        return this.componentData_;
    }

    public void setComponentData(ComponentData componentData) {
        this.componentData_ = componentData;
        if (this.componentData_ == null) {
            this.componentData_ = new ComponentData();
        }
        this.init();
        IDataBean impl = this.componentData_.getImplementation();
        if (impl == null) {
            this.hasImpl = false;
            this.replaceImplDeclaration.setVisible(false);
        } else {
            this.hasImpl = true;
            this.replaceImplDeclaration.setVisible(true);
        }
    }

    public void setComponentService(ComponentService componentService) {
        this.isComponentServiceSet_ = true;
        this.componentService_ = componentService;
        this.init();
    }

    public void init() {
        if (this.isProjectSet_ && this.componentData_ != null && this.isComponentServiceSet_) {
            IDataBean intf = null;
            try {
                intf = RecognizeInterfaceCommand.recognize(this.componentData_.getComposite(), this.componentService_);
            }
            catch (RecognitionException e) {
                this.noIntfError = e.getStatus();
            }
            this.componentData_.setServiceInterface(intf);
            if (this.componentService_ != null) {
                this.componentData_.setServiceName(this.componentService_.getName());
            }
            this.populateImplTypes(this.implTypeCombo_);
            this.initSelection();
        }
    }

    private void initSelection() {
        IDataBean impl = this.componentData_.getImplementation();
        if (impl != null) {
            this.selectIntfOrImplCombo(this.implTypeCombo_, impl.getID());
        }
    }
}

