/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.extension;

import com.ibm.ccl.sca.core.tracing.LogWriter;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.extension.IDataBeanValidator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class WizardConfigStore {
    private static WizardConfigStore storeInstance;
    private Map<String, WizardConfig> configs;
    private Map<String, Validator> intfValidators;
    private Map<String, Validator> implValidators;
    private LogWriter logger = new LogWriter();

    public static WizardConfigStore getInstance() {
        if (storeInstance == null) {
            storeInstance = new WizardConfigStore();
        }
        return storeInstance;
    }

    private WizardConfigStore() {
        this.configs = new HashMap<String, WizardConfig>();
        this.intfValidators = new HashMap<String, Validator>();
        this.implValidators = new HashMap<String, Validator>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ccl.sca.creation.ui", "newComponentWizard");
        int i = 0;
        while (i < elements.length) {
            block8: {
                String validator;
                String id;
                IConfigurationElement configElement;
                block9: {
                    block7: {
                        configElement = elements[i];
                        if (!configElement.getName().equals("Config")) break block7;
                        id = configElement.getAttribute("fragmentID");
                        if (id == null || id.length() == 0) break block8;
                        String finish = configElement.getAttribute("canFinishOnPageOne");
                        boolean canFinish = true;
                        if (finish != null && finish.equalsIgnoreCase("false")) {
                            canFinish = false;
                        }
                        this.configs.put(id, new WizardConfig(id, canFinish));
                    }
                    if (!configElement.getName().equals("ServiceInterfaceValidator")) break block9;
                    id = configElement.getAttribute("id");
                    validator = configElement.getAttribute("validator");
                    if (id == null || id.length() == 0 || validator == null || validator.length() == 0) break block8;
                    Validator validatorHolder = new Validator(id, validator, configElement);
                    this.intfValidators.put(id, validatorHolder);
                }
                if (configElement.getName().equals("ImplementationValidator")) {
                    id = configElement.getAttribute("id");
                    validator = configElement.getAttribute("validator");
                    if (id != null && id.length() != 0 && validator != null && validator.length() != 0) {
                        Validator validatorHolder = new Validator(id, validator, configElement);
                        this.implValidators.put(id, validatorHolder);
                    }
                }
            }
            ++i;
        }
    }

    public boolean canFinishOnPageOne(String id) {
        WizardConfig config = this.configs.get(id);
        if (config != null) {
            return config.canFinishOnPageOne;
        }
        return true;
    }

    public IDataBeanValidator getServiceInterfaceValidator(String id) {
        Validator validatorHodler = this.intfValidators.get(id);
        if (validatorHodler == null) {
            return null;
        }
        try {
            Object validator;
            IConfigurationElement validatorElement = validatorHodler.element;
            if (validatorElement != null && (validator = validatorElement.createExecutableExtension("validator")) != null && validator instanceof IDataBeanValidator) {
                return (IDataBeanValidator)validator;
            }
        }
        catch (Exception e) {
            this.logger.write((Plugin)Activator.getDefault(), 4, (Throwable)e);
        }
        return null;
    }

    public IDataBeanValidator getImplementationValidator(String id) {
        Validator validatorHodler = this.implValidators.get(id);
        if (validatorHodler == null) {
            return null;
        }
        try {
            Object validator;
            IConfigurationElement validatorElement = validatorHodler.element;
            if (validatorElement != null && (validator = validatorElement.createExecutableExtension("validator")) != null && validator instanceof IDataBeanValidator) {
                return (IDataBeanValidator)validator;
            }
        }
        catch (Exception e) {
            this.logger.write((Plugin)Activator.getDefault(), 4, (Throwable)e);
        }
        return null;
    }

    private class Validator {
        String id;
        String validator;
        IConfigurationElement element;

        public Validator(String id, String validator, IConfigurationElement element) {
            this.id = id;
            this.validator = validator;
            this.element = element;
        }
    }

    private class WizardConfig {
        String id;
        boolean canFinishOnPageOne;

        public WizardConfig(String id, boolean canFinish) {
            this.id = id;
            this.canFinishOnPageOne = canFinish;
        }
    }
}

