/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.dialogs;

import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.tracing.LogWriter;
import com.ibm.ccl.sca.core.util.JavaUtil;
import com.ibm.ccl.sca.core.util.PlatformUtil;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.facets.core.impltype.IImplTypePreferenceProvider;
import com.ibm.ccl.sca.internal.core.bean.implementations.Java;
import com.ibm.ccl.sca.internal.core.bean.interfaces.WSDL;
import com.ibm.ccl.sca.internal.creation.core.command.CopyGeneratedJavaFilesCommand;
import com.ibm.ccl.sca.internal.creation.core.command.SDOModifyCommand;
import com.ibm.ccl.sca.internal.creation.core.command.SDOUtil;
import com.ibm.ccl.sca.internal.creation.core.command.WsImportCommand;
import com.ibm.ccl.sca.internal.creation.core.data.ComponentData;
import com.ibm.ccl.sca.internal.creation.ui.widgets.JavaImplConfigWidget;
import com.ibm.ccl.sca.ui.util.UIUtils;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jst.ws.internal.ui.common.DialogResourceBrowser;
import org.eclipse.jst.ws.internal.ui.common.FileExtensionFilter;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;

public class WSDL2JavaDialog
extends TitleAreaDialog {
    private static final String INFOPOP_WSDL2JAVA_DIALOG = "com.ibm.ccl.sca.creation.ui.WSDL2JAVA_DIALOG";
    private Combo sourceFolderCombo;
    private Combo packageCombo;
    private Combo projectCombo;
    private Combo dataBindingCombo;
    private Button browseWSDLButton;
    private Button overwriteCheckBox;
    private Text wsdlFileText;
    private IFile wsdlFile;
    private Map<String, IJavaProject> javaProjectMap;
    private IJavaProject outputProject;
    private LogWriter logger;
    private IImplTypePreferenceProvider provider;

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.WSDL2JavaDialog_SECOND_TITLE);
        this.setMessage(Messages.WSDL2JavaDialog_DESCRIPTION);
        this.setTitleImage(Activator.getImageDescriptor("icons/wsdl2java_obj.gif").createImage());
        Composite control = (Composite)super.createDialogArea(parent);
        UIUtils utils = new UIUtils("com.ibm.ccl.sca.creation.ui");
        Composite comp = utils.createComposite(control, 3);
        GridLayout layout = (GridLayout)comp.getLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.wsdlFileText = utils.createText(comp, Messages.WSDL2JavaDialog_LABEL_WSDL_FILE, null, null, 2048);
        this.browseWSDLButton = utils.createPushButton(comp, Messages.WSDL2JavaDialog_BUTTON_BROWSE, null, null);
        this.projectCombo = utils.createCombo(comp, Messages.WSDL2JavaDialog_LABEL_OUTPUT_PROJECT, null, null, 8);
        new Label(comp, 0);
        this.sourceFolderCombo = utils.createCombo(comp, Messages.WSDL2JavaDialog_LABEL_SOURCE_FOLDER, null, null, 8);
        new Label(comp, 0);
        this.dataBindingCombo = utils.createCombo(comp, Messages.LABEL_DATA_BINDING, null, null, 8);
        new Label(comp, 0);
        this.packageCombo = utils.createCombo(comp, Messages.WSDL2JavaDialog_LABEL_PACKAGE_NAME, null, null, 2048);
        new Label(comp, 0);
        this.wsdlFileText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                WSDL2JavaDialog.this.getButton(0).setEnabled(WSDL2JavaDialog.this.validate());
            }
        });
        this.browseWSDLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileExtensionFilter wsdlFilter = new FileExtensionFilter(new String[]{"wsdl"});
                DialogResourceBrowser dialog = new DialogResourceBrowser(WSDL2JavaDialog.this.getShell(), null, (IFilter)wsdlFilter);
                if (dialog.open() == 0) {
                    WSDL2JavaDialog.this.wsdlFile = (IFile)dialog.getFirstSelection();
                    WSDL2JavaDialog.this.wsdlFileText.setText(WSDL2JavaDialog.this.wsdlFile.getFullPath().toString());
                }
            }
        });
        this.projectCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDL2JavaDialog.this.outputProject = (IJavaProject)WSDL2JavaDialog.this.javaProjectMap.get(WSDL2JavaDialog.this.projectCombo.getText());
                WSDL2JavaDialog.this.sourceFolderCombo.removeAll();
                try {
                    IClasspathEntry[] iClasspathEntryArray = WSDL2JavaDialog.this.outputProject.getResolvedClasspath(true);
                    int n = iClasspathEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IClasspathEntry classPath = iClasspathEntryArray[n2];
                        if (classPath.getEntryKind() == 3) {
                            WSDL2JavaDialog.this.sourceFolderCombo.add(classPath.getPath().toString());
                        }
                        ++n2;
                    }
                    if (WSDL2JavaDialog.this.sourceFolderCombo.getItemCount() > 0) {
                        WSDL2JavaDialog.this.sourceFolderCombo.select(0);
                    }
                }
                catch (JavaModelException e1) {
                    WSDL2JavaDialog.this.logger.write((Plugin)Activator.getDefault(), 4, (Throwable)e1);
                }
                WSDL2JavaDialog.this.selectDataBinding(WSDL2JavaDialog.this.outputProject.getProject());
                WSDL2JavaDialog.this.getButton(0).setEnabled(WSDL2JavaDialog.this.validate());
            }
        });
        this.dataBindingCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WSDL2JavaDialog.this.getButton(0).setEnabled(WSDL2JavaDialog.this.validate());
            }
        });
        this.packageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Button okButton = WSDL2JavaDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(WSDL2JavaDialog.this.validate());
                }
            }
        });
        Label bottomSeparator = new Label(comp, 258);
        GridData griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        bottomSeparator.setLayoutData((Object)griddata);
        this.overwriteCheckBox = utils.createCheckbox(comp, Messages.WSDL2JavaDialog_LABEL_OVERWRITE_FILES, null, null);
        griddata = new GridData(768);
        griddata.horizontalSpan = 3;
        this.overwriteCheckBox.setLayoutData((Object)griddata);
        this.init();
        return control;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        if (this.projectCombo.getText().length() == 0) {
            this.getButton(0).setEnabled(false);
        }
        return control;
    }

    private void selectDataBinding(IProject project) {
        if (this.provider != null) {
            int index = JavaImplConfigWidget.getDataBindingIndex(this.provider, project);
            this.dataBindingCombo.select(index);
        }
    }

    private void init() {
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                IProject project = iProjectArray[n2];
                if (project.isOpen()) {
                    boolean isJavaProject;
                    try {
                        isJavaProject = project.hasNature("org.eclipse.jdt.core.javanature");
                    }
                    catch (CoreException coreException) {
                        break block13;
                    }
                    if (isJavaProject) {
                        this.projectCombo.add(project.getName());
                        this.javaProjectMap.put(project.getName(), JavaCore.create((IProject)project));
                    }
                }
            }
            ++n2;
        }
        this.provider = JavaImplConfigWidget.getPreferenceProvider();
        if (this.provider != null) {
            this.dataBindingCombo.setItems(this.provider.getValueLabels("com.ibm.ccl.sca.java.core.dataBinding"));
        }
        this.packageCombo.add(Messages.WSDL2JavaDialog_DEFAULT_NAMESPACE2PACKAG_MAPPING);
        this.packageCombo.select(0);
        if (this.wsdlFile != null) {
            this.wsdlFileText.setText(this.wsdlFile.getFullPath().toString());
            String currentProjectName = this.wsdlFile.getProject().getName();
            this.outputProject = this.javaProjectMap.get(currentProjectName);
            if (this.outputProject != null) {
                this.projectCombo.setText(currentProjectName);
                try {
                    IClasspathEntry[] iClasspathEntryArray = this.outputProject.getResolvedClasspath(true);
                    int n3 = iClasspathEntryArray.length;
                    n = 0;
                    while (n < n3) {
                        IClasspathEntry classPath = iClasspathEntryArray[n];
                        if (classPath.getEntryKind() == 3) {
                            this.sourceFolderCombo.add(classPath.getPath().toString());
                        }
                        ++n;
                    }
                }
                catch (JavaModelException e) {
                    this.logger.write((Plugin)Activator.getDefault(), 4, (Throwable)e);
                }
                if (this.sourceFolderCombo.getItemCount() > 0) {
                    this.sourceFolderCombo.select(0);
                }
                this.selectDataBinding(this.outputProject.getProject());
            }
        }
    }

    protected void okPressed() {
        final String sourceFolderPath = this.sourceFolderCombo.getText();
        final String packageName = this.packageCombo.getText();
        final boolean overwrite = this.overwriteCheckBox.getSelection();
        final int dataBindingIndex = this.dataBindingCombo.getSelectionIndex();
        WorkspaceJob job = new WorkspaceJob(Messages.bind((String)Messages.WSDL2JavaDialog_JOB_NAME, (Object)this.wsdlFile.getFullPath().toString())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                IStatus status = Status.OK_STATUS;
                WSDL wsdl = new WSDL();
                URI wsdlURI = WSDL2JavaDialog.this.wsdlFile.getLocation().toFile().toURI();
                wsdl.setWsdlURI(wsdlURI);
                Java javaImpl = new Java();
                javaImpl.setProject(WSDL2JavaDialog.this.outputProject.getProject());
                IFolder sourceFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(sourceFolderPath));
                javaImpl.setSourceFolder(sourceFolder);
                if (!packageName.equals(Messages.WSDL2JavaDialog_DEFAULT_NAMESPACE2PACKAG_MAPPING)) {
                    javaImpl.setJaxbPackageName(packageName);
                }
                ComponentData componentData = new ComponentData();
                componentData.setServiceInterface((IDataBean)wsdl);
                componentData.setImplementation((IDataBean)javaImpl);
                WsImportCommand wsImport = new WsImportCommand();
                wsImport.setComponentData(componentData);
                String outputSrcLocation = WSDL2JavaDialog.this.createOutputDirectory();
                wsImport.setOutputSrcLocation(outputSrcLocation);
                status = wsImport.execute(monitor, null);
                if (status.getSeverity() == 4) {
                    WSDL2JavaDialog.this.logger.write((Plugin)Activator.getDefault(), status);
                    return status;
                }
                CopyGeneratedJavaFilesCommand copyFiles = new CopyGeneratedJavaFilesCommand(true);
                copyFiles.setProject(sourceFolder.getProject());
                copyFiles.setComponentData(componentData);
                copyFiles.setOutputSrcLocation(outputSrcLocation);
                boolean useSDO = false;
                if (WSDL2JavaDialog.this.provider != null) {
                    String value = WSDL2JavaDialog.this.provider.getValues("com.ibm.ccl.sca.java.core.dataBinding")[dataBindingIndex];
                    useSDO = "sdo_2.1.1_dynamic".equals(value);
                }
                List seis = null;
                if (useSDO) {
                    seis = SDOUtil.makeUniqueList(wsImport.getPortSEIMapping().values());
                    copyFiles.addIncludeClasses(seis);
                    copyFiles.addIncludeClasses(wsImport.getExceptionClasses());
                } else {
                    copyFiles.setOmitFileList(new HashSet(wsImport.getServiceClassNameMapping().values()));
                }
                TemporaryResourceContext context = new TemporaryResourceContext(overwrite);
                EclipseStatusHandler handler = new EclipseStatusHandler();
                EclipseEnvironment environment = new EclipseEnvironment(null, (ResourceContext)context, (IStatusHandler)handler);
                copyFiles.setEnvironment((IEnvironment)environment);
                status = copyFiles.execute(monitor, null);
                if (status.getSeverity() == 4) {
                    WSDL2JavaDialog.this.logger.write((Plugin)Activator.getDefault(), status);
                    return status;
                }
                if (useSDO) {
                    SDOModifyCommand sdo = new SDOModifyCommand();
                    sdo.setProject(WSDL2JavaDialog.this.outputProject.getProject());
                    sdo.setSEIs(seis);
                    sdo.setExceptionClasses(wsImport.getExceptionClasses());
                    String pkgName = javaImpl.getJaxbPackageName();
                    if (pkgName == null) {
                        pkgName = JavaUtil.getPackageNameFromClassName((String)((String)seis.get(0)));
                    }
                    sdo.setParameterClasses(pkgName, (Set)wsImport.getMethodParameterClasses());
                    status = sdo.execute(monitor, null);
                    if (status.getSeverity() == 4) {
                        WSDL2JavaDialog.this.logger.write((Plugin)Activator.getDefault(), status);
                        return status;
                    }
                }
                if (status.getMessage().length() == 0 && status.getException() == null) {
                    return Status.OK_STATUS;
                }
                return status;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
        super.okPressed();
    }

    private String createOutputDirectory() {
        IProject proj = this.outputProject.getProject();
        File outputDir = PlatformUtil.createTempDir((String)"com.ibm.ccl.sca.creation.core", (IProject)proj);
        return outputDir.getAbsolutePath();
    }

    private boolean validate() {
        IStatus status;
        String wsdlPath = this.wsdlFileText.getText();
        if (!wsdlPath.endsWith(".wsdl")) {
            this.setErrorMessage(Messages.WSDL2JavaDialog_INVALID_WSDL_FILE_PATH);
            return false;
        }
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.wsdlFile = wsRoot.getFile((IPath)new Path(wsdlPath));
        if (this.wsdlFile == null || !this.wsdlFile.exists()) {
            this.setErrorMessage(Messages.WSDL2JavaDialog_INVALID_WSDL_FILE_PATH);
            return false;
        }
        if (this.dataBindingCombo.getSelectionIndex() == 1 && !SDOUtil.supportsSDO((IProject)this.outputProject.getProject())) {
            this.setErrorMessage(Messages.ERROR_PROJECT_DOES_NOT_SUPPORT_SDO);
            return false;
        }
        String packageName = this.packageCombo.getText();
        if (!packageName.equals(Messages.WSDL2JavaDialog_DEFAULT_NAMESPACE2PACKAG_MAPPING) && !(status = JavaConventions.validatePackageName((String)packageName, (String)"1.5", (String)"1.5")).isOK()) {
            if (status.getSeverity() == 4) {
                this.setErrorMessage(status.getMessage());
                return false;
            }
            if (status.getSeverity() == 2) {
                this.setMessage(status.getMessage(), 2);
            }
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.WSDL2JavaDialog_DESCRIPTION);
        return true;
    }

    public WSDL2JavaDialog(Shell parentShell, IFile wsdlFile) {
        super(parentShell);
        this.wsdlFile = wsdlFile;
        this.javaProjectMap = new HashMap<String, IJavaProject>();
        this.logger = new LogWriter();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.WSDL2JavaDialog_TITLE_WSDL2JAVA);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, INFOPOP_WSDL2JAVA_DIALOG);
    }

    private class TemporaryResourceContext
    implements ResourceContext {
        private boolean overwrite;
        private boolean checkout = true;
        private boolean createFolder = true;

        public TemporaryResourceContext(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public boolean isOverwriteFilesEnabled() {
            return this.overwrite;
        }

        public void setOverwriteFilesEnabled(boolean enable) {
            this.overwrite = enable;
        }

        public ResourceContext copy() {
            return this;
        }

        public boolean isCheckoutFilesEnabled() {
            return this.checkout;
        }

        public boolean isCreateFoldersEnabled() {
            return this.createFolder;
        }

        public void setCheckoutFilesEnabled(boolean enable) {
            this.checkout = enable;
        }

        public void setCreateFoldersEnabled(boolean enable) {
            this.createFolder = enable;
        }
    }
}

