/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.dialogs;

import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import com.ibm.ccl.sca.internal.creation.core.command.ReflectComponentImplementationCommand;
import com.ibm.ccl.sca.tuscany.TuscanyModelHelper;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ServiceReferenceDeltaAnalyzer {
    private ISCAComposite scaComposite;
    private String componentName;
    private Composite composite;
    private Component component;
    private Map<String, ComponentService> definedServices;
    private Map<String, ComponentReference> definedReferences;
    private List<ServiceReferenceDelta<ComponentService>> serviceDeltas;
    private List<ServiceReferenceDelta<ComponentReference>> referenceDeltas;

    public ServiceReferenceDeltaAnalyzer(ISCAComposite composite, String componentName) {
        this.scaComposite = composite;
        this.componentName = componentName;
    }

    private Component getComponent(Composite composite, String componentName) {
        for (Component component : composite.getComponents()) {
            if (!component.getName().equals(componentName)) continue;
            return component;
        }
        return null;
    }

    private <T extends AbstractContract> Map<String, T> createMap(List<T> fromComposite) {
        Hashtable<String, AbstractContract> defined = new Hashtable<String, AbstractContract>();
        for (AbstractContract t : fromComposite) {
            defined.put(t.getName(), t);
        }
        return defined;
    }

    private <T extends AbstractContract> List<ServiceReferenceDelta<T>> calculateDeltas(Map<String, T> defined, List<T> fromImpl) {
        ArrayList<ServiceReferenceDelta<T>> deltas = new ArrayList<ServiceReferenceDelta<T>>();
        ArrayList<String> names = new ArrayList<String>(defined.keySet());
        for (AbstractContract t : fromImpl) {
            String name = t.getName();
            if (!names.contains(name)) {
                deltas.add(new ServiceReferenceDelta<AbstractContract>(name, t, ServiceReferenceDelta.Kind.ADD));
                continue;
            }
            deltas.add(new ServiceReferenceDelta<AbstractContract>(name, t, ServiceReferenceDelta.Kind.CHANGE));
            names.remove(name);
        }
        for (String name : names) {
            AbstractContract t = (AbstractContract)defined.get(name);
            deltas.add(new ServiceReferenceDelta<AbstractContract>(name, t, ServiceReferenceDelta.Kind.REMOVE));
        }
        return deltas;
    }

    public IStatus init() {
        try {
            if (this.scaComposite != null) {
                this.composite = (Composite)this.scaComposite.getModelObject();
                this.component = this.getComponent(this.composite, this.componentName);
            }
            if (this.component == null) {
                return StatusUtil.errorStatus((String)Messages.bind((String)Messages.ERROR_REFRESH_COMPONENT_UNKNOWN_COMPONENT, (Object)this.componentName));
            }
            ReflectComponentImplementationCommand command = new ReflectComponentImplementationCommand();
            command.setComponent(this.component);
            command.setProject(this.scaComposite.getParent());
            IStatus status = command.execute(null, null);
            if (!status.isOK()) {
                return status;
            }
            this.definedServices = this.createMap(this.component.getServices());
            this.definedReferences = this.createMap(this.component.getReferences());
            this.serviceDeltas = this.calculateDeltas(this.definedServices, command.getServices());
            this.referenceDeltas = this.calculateDeltas(this.definedReferences, command.getReferences());
            if (this.serviceDeltas.isEmpty() && this.referenceDeltas.isEmpty()) {
                return StatusUtil.infoStatus((String)Messages.INFO_REFRESH_COMPONENT_NOTHING_TO_UPDATE);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        catch (ExecutionException e) {
            return StatusUtil.errorStatus((Throwable)e);
        }
    }

    public List<ServiceReferenceDelta<ComponentService>> getServiceDeltas() {
        return this.serviceDeltas;
    }

    public List<ServiceReferenceDelta<ComponentReference>> getReferenceDeltas() {
        return this.referenceDeltas;
    }

    public boolean isService(ServiceReferenceDelta<?> delta) {
        return delta.get() instanceof ComponentService;
    }

    private <T extends AbstractContract> void updateMap(Map<String, T> defined, ServiceReferenceDelta<?> delta, Class<T> clz) {
        switch (delta.getKind()) {
            case ADD: 
            case CHANGE: {
                defined.put(delta.getName(), (AbstractContract)clz.cast(delta.get()));
                break;
            }
            case REMOVE: {
                defined.remove(delta.getName());
            }
        }
    }

    private IStatus writeFile() {
        this.component.getServices().clear();
        this.component.getServices().addAll(this.definedServices.values());
        this.component.getReferences().clear();
        this.component.getReferences().addAll(this.definedReferences.values());
        return TuscanyModelHelper.getInstance().writeCompositeToFile(this.scaComposite.getResource().getParent(), this.composite);
    }

    public IStatus performUpdate(Object[] checkedElements) {
        Object[] objectArray = checkedElements;
        int n = checkedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object checked = objectArray[n2];
            if (!(checked instanceof String)) {
                ServiceReferenceDelta delta = (ServiceReferenceDelta)checked;
                if (this.isService(delta)) {
                    this.updateMap(this.definedServices, delta, ComponentService.class);
                } else {
                    this.updateMap(this.definedReferences, delta, ComponentReference.class);
                }
            }
            ++n2;
        }
        return this.writeFile();
    }

    static class ServiceReferenceDelta<T extends AbstractContract> {
        private String name;
        private T t;
        private Kind kind;

        public ServiceReferenceDelta(String name, T t, Kind kind) {
            this.name = name;
            this.t = t;
            this.kind = kind;
        }

        public String getName() {
            return this.name;
        }

        public T get() {
            return this.t;
        }

        public Kind getKind() {
            return this.kind;
        }

        static enum Kind {
            ADD,
            CHANGE,
            REMOVE;

        }
    }
}

