/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.internal.creation.ui.command;

import com.ibm.ccl.sca.core.tracing.LogWriter;
import com.ibm.ccl.sca.creation.ui.Activator;
import com.ibm.ccl.sca.creation.ui.messages.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogBlockedHandler;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class RunWithProgressCommand
extends AbstractDataModelOperation {
    private IWorkspaceRunnable runnable = null;
    private ISchedulingRule rule = null;
    private LogWriter logger = new LogWriter();

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.runnable != null) {
            try {
                ProgressMonitorWrapper wrapper = new ProgressMonitorWrapper(monitor){
                    IDialogBlockedHandler blockedHandler;
                    {
                        this.blockedHandler = Dialog.getBlockedHandler();
                    }

                    public void clearBlocked() {
                        this.blockedHandler.clearBlocked();
                        super.clearBlocked();
                    }

                    public void setBlocked(IStatus reason) {
                        Dialog.getBlockedHandler().showBlocked(Display.getDefault().getActiveShell(), this.getWrappedProgressMonitor(), reason, Messages.MSG_WAITING_USER_OPERATION);
                        super.setBlocked(reason);
                    }
                };
                ModalContext.run((IRunnableWithProgress)new WorkspaceModifyOperation(this.rule){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        RunWithProgressCommand.this.runnable.run(monitor);
                    }
                }, (boolean)true, (IProgressMonitor)wrapper, (Display)Display.getDefault());
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof CoreException) {
                    return ((CoreException)cause).getStatus();
                }
                this.logger.write((Plugin)Activator.getDefault(), 4, (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.write((Plugin)Activator.getDefault(), 8, (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public void setRunnable(IWorkspaceRunnable runnable) {
        this.runnable = runnable;
    }

    public void setRule(ISchedulingRule rule) {
        this.rule = rule;
    }
}

