/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.sheet;

import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.CompositeEditorContextIDs;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAEditServicePromoteAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.DelayedTextModifyListener;
import com.ibm.ccl.sca.composite.ui.custom.mixed.HasChildrenFilter;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedComponent;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedComposite;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedItem;
import com.ibm.ccl.sca.composite.ui.custom.mixed.MixedUtils;
import com.ibm.ccl.sca.composite.ui.custom.promote.DialogPromoteContentProvider;
import com.ibm.ccl.sca.composite.ui.custom.promote.DialogPromoteLabelProvider;
import com.ibm.ccl.sca.composite.ui.custom.promote.EditPromoteCommand;
import com.ibm.ccl.sca.composite.ui.custom.promote.HasSamePromoteFilter;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.composite.ui.sheet.SCAComponentServicePropertySection;
import com.ibm.ccl.sca.internal.ui.common.controls.SelectionDialog;
import com.ibm.ccl.sca.internal.ui.common.controls.ValidateSelectedContentProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SCAServicePropertySection
extends SCAComponentServicePropertySection {
    private Text promoteText;
    private ComponentTextListener textListener = new ComponentTextListener();

    public SCAServicePropertySection() {
        this.contextID = CompositeEditorContextIDs.INFOPOP_COMPOSITE_SERVICE_PROPERTIES_CORE_TAB;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.removeListeners();
        this.promoteText.setText("");
        String promoteString = this.getService().getPromote();
        if (promoteString != null) {
            this.promoteText.setText(promoteString);
        }
        this.addListeners();
    }

    @Override
    public void createExtendedArea(Composite parent) {
        this.toolkit.createLabel(parent, Messages.SCAServicePropertySection_2);
        Composite promoteComposite = this.toolkit.createComposite(parent);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginWidth = 0;
        gl.marginLeft = 1;
        gl.marginHeight = 0;
        promoteComposite.setLayout((Layout)gl);
        promoteComposite.setLayoutData((Object)new GridData(768));
        this.promoteText = this.createTextField(promoteComposite, 8);
        this.promoteText.setLayoutData((Object)new GridData(768));
        Button browseButton = this.toolkit.createButton(promoteComposite, Messages.SCAServicePropertySection_1, 8);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SCAServicePropertySection.this.handlePromoteBrowse();
            }
        });
        this.toolkit.paintBordersFor(promoteComposite);
    }

    private void handlePromoteBrowse() {
        SelectionDialog diag = new SelectionDialog(null, Messages.AddServiceAction_0, true);
        Service service = this.getService();
        HasChildrenFilter<MixedComposite> compositeFilter = new HasChildrenFilter<MixedComposite>(true);
        HasChildrenFilter<MixedComponent> componentFilter = new HasChildrenFilter<MixedComponent>(true);
        HasSamePromoteFilter itemFilter = new HasSamePromoteFilter((EObject)service);
        diag.setLabelProvider((IBaseLabelProvider)new DialogPromoteLabelProvider(true));
        diag.setContentProvider((ValidateSelectedContentProvider)new DialogPromoteContentProvider(true));
        diag.setRoot(MixedUtils.getRootComposites((EObject)service, compositeFilter, componentFilter, itemFilter));
        int code = diag.open();
        Object selection = diag.getSelection();
        if (code == 0 && selection != null && (selection instanceof MixedItem || selection instanceof String)) {
            SetRequest request = new SetRequest((EObject)service, null, this.getPromoteList(selection));
            EditPromoteCommand command = new EditPromoteCommand(request, true);
            String oldPromoteValue = service.getPromote();
            CompositeCommand compositeCommand = new CompositeCommand("");
            compositeCommand.add((IUndoableOperation)command);
            if (oldPromoteValue != null) {
                ScaUtil.addRemoveWiresCommand(oldPromoteValue, compositeCommand, true, true);
            }
            List<String> addEdges = ScaUtil.edgesToAdd((List)request.getValue(), true);
            ScaUtil.addUpdateWiresCommand(addEdges, compositeCommand, true);
            try {
                compositeCommand.execute(null, null);
                this.refresh();
            }
            catch (Exception e) {
                ScaDiagramEditorPlugin.traceError(e);
            }
        }
    }

    private List<String> getPromoteList(Object selection) {
        ArrayList<String> newList = new ArrayList<String>();
        String newName = null;
        if (selection instanceof MixedItem) {
            newName = ((MixedItem)selection).getRelativePath();
        } else if (selection instanceof String) {
            newName = (String)selection;
        }
        newList.add(newName);
        return newList;
    }

    private void addListeners() {
        this.promoteText.addListener(16, (Listener)this.textListener);
        this.promoteText.addListener(2, (Listener)this.textListener);
    }

    private void removeListeners() {
        this.promoteText.removeListener(16, (Listener)this.textListener);
        this.promoteText.removeListener(2, (Listener)this.textListener);
    }

    private Service getService() {
        return (Service)this.inputObjects.get(0);
    }

    private class ComponentTextListener
    extends DelayedTextModifyListener {
        private ComponentTextListener() {
        }

        @Override
        protected void executeHandleEvent(Event event) {
            if (event.widget == SCAServicePropertySection.this.promoteText && !SCAServicePropertySection.this.promoteText.isDisposed()) {
                String text = SCAServicePropertySection.this.promoteText.getText();
                SCAEditServicePromoteAction action = new SCAEditServicePromoteAction(SCAServicePropertySection.this.getPart(), SCAServicePropertySection.this.getService(), text);
                action.run();
            }
        }
    }
}

