/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.sheet;

import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.ComponentService;
import com.ibm.ccl.sca.composite.emf.sca.Interface;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.CompositeEditorContextIDs;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAEditInterfaceCallbackAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCALaunchSelectionDialogAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCARemoveInterfaceAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.DelayedTextModifyListener;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.interfaze.SCAInterfaceExtensibilityUtil;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUiUtil;
import com.ibm.ccl.sca.composite.ui.sheet.SCANonAdvancedBasePropertySection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class SCABaseInterfacePropertySection
extends SCANonAdvancedBasePropertySection {
    private SCABaseTextListener textListener = new SCABaseTextListener();
    private FormToolkit toolkit;
    private ManagedForm form;
    private Section section;
    private CCombo interfaceTypeCombo;
    private Text interfaceText;
    private Text callBackInterfaceText;
    private SCAInterfaceExtensibilityUtil util = new SCAInterfaceExtensibilityUtil();
    private Button addInterfaceButton;
    private Button addCallbackInterfaceButton;
    private InterfaceButtonSelectionListener buttonListener = new InterfaceButtonSelectionListener();
    private InterfaceComboListener comboListener = new InterfaceComboListener();
    private AdapterImplNotifier modelNotifier = new AdapterImplNotifier();

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object oldObject = null;
        if (this.inputObjects.size() > 0) {
            oldObject = this.inputObjects.get(0);
        }
        super.setInput(part, selection);
        EObject newEObject = (EObject)this.inputObjects.get(0);
        if (!newEObject.equals(oldObject)) {
            Interface oldInterface;
            if (oldObject instanceof EObject && ((EObject)oldObject).eAdapters().contains((Object)this.modelNotifier)) {
                ((EObject)oldObject).eAdapters().remove((Object)this.modelNotifier);
            }
            if ((oldInterface = this.getInterface(oldObject)) != null && oldInterface.eAdapters().contains((Object)this.modelNotifier)) {
                oldInterface.eAdapters().remove((Object)this.modelNotifier);
            }
            newEObject.eAdapters().add((Object)this.modelNotifier);
            Interface newInterface = this.getInterface(newEObject);
            if (newInterface != null) {
                newInterface.eAdapters().add((Object)this.modelNotifier);
            }
        }
    }

    public void dispose() {
        if (this.inputObjects.size() == 0) {
            return;
        }
        Object o = this.inputObjects.get(0);
        if (o != null && ((EObject)o).eAdapters().contains((Object)this.modelNotifier)) {
            ((EObject)o).eAdapters().remove((Object)this.modelNotifier);
            Interface theInterface = this.getInterface(o);
            if (theInterface != null) {
                theInterface.eAdapters().remove((Object)this.modelNotifier);
            }
        }
        this.form.dispose();
        this.section.dispose();
        super.dispose();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ccl.sca.composite.ui." + CompositeEditorContextIDs.INFOPOP_PROPERTIES_INTERFACE_TAB);
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        this.form = new ManagedForm(parent);
        GridLayout layout = new GridLayout();
        Composite topComposite = this.form.getForm().getBody();
        topComposite.setLayout((Layout)layout);
        this.toolkit = this.form.getToolkit();
        this.section = this.toolkit.createSection(topComposite, 256);
        this.section.setLayoutData((Object)new GridData(1808));
        this.section.setLayout((Layout)new GridLayout());
        this.section.setText(Messages.SCABaseInterfacePropertySection_2);
        Composite composite = this.toolkit.createComposite((Composite)this.section);
        composite.setLayout((Layout)new GridLayout());
        this.createInterfaceControls(composite);
        this.section.setClient((Control)composite);
        this.toolkit.paintBordersFor(composite);
    }

    private void createInterfaceControls(Composite interfaceComp) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        gl.marginWidth = 0;
        gl.marginRight = 1;
        interfaceComp.setLayout((Layout)gl);
        interfaceComp.setLayoutData((Object)new GridData(1808));
        this.toolkit.createLabel(interfaceComp, Messages.TEXT_INTERFACE_TYPE);
        this.interfaceTypeCombo = ScaUiUtil.createCCombo(this.toolkit, interfaceComp, 0x800000);
        this.interfaceTypeCombo.setEditable(false);
        GridData gd = new GridData(770);
        gd.horizontalSpan = 1;
        this.interfaceTypeCombo.setLayoutData((Object)gd);
        Iterator<String> labels = this.util.getInterfaceLabels().iterator();
        this.interfaceTypeCombo.add("");
        while (labels.hasNext()) {
            this.interfaceTypeCombo.add(labels.next());
        }
        this.toolkit.createLabel(interfaceComp, "");
        this.toolkit.createLabel(interfaceComp, Messages.SCABaseInterfacePropertySection_9);
        this.interfaceText = this.toolkit.createText(interfaceComp, "", 4);
        gd = new GridData(770);
        gd.verticalAlignment = 0x1000000;
        this.interfaceText.setLayoutData((Object)gd);
        this.addInterfaceButton = this.toolkit.createButton(interfaceComp, Messages.SCAServicePropertySection_1, 8);
        this.addInterfaceButton.addSelectionListener((SelectionListener)this.buttonListener);
        this.toolkit.createLabel(interfaceComp, Messages.SCABaseInterfacePropertySection_11);
        this.callBackInterfaceText = this.toolkit.createText(interfaceComp, "", 4);
        gd = new GridData(770);
        gd.verticalAlignment = 0x1000000;
        this.callBackInterfaceText.setLayoutData((Object)gd);
        this.addCallbackInterfaceButton = this.toolkit.createButton(interfaceComp, Messages.SCAServicePropertySection_1, 8);
        this.addCallbackInterfaceButton.addSelectionListener((SelectionListener)this.buttonListener);
        this.toolkit.createLabel(interfaceComp, "");
        this.toolkit.createLabel(interfaceComp, "");
        this.toolkit.paintBordersFor(interfaceComp);
    }

    private Interface getInterface(Object object) {
        if (object instanceof Service) {
            return ((Service)object).getInterface();
        }
        if (object instanceof Reference) {
            return ((Reference)object).getInterface();
        }
        if (object instanceof ComponentService) {
            return ((ComponentService)object).getInterface();
        }
        if (object instanceof ComponentReference) {
            return ((ComponentReference)object).getInterface();
        }
        return null;
    }

    private void selectComboItem(CCombo combo, String string) {
        String[] items = combo.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(string)) {
                combo.select(i);
                break;
            }
            ++i;
        }
    }

    private void enableControls(boolean enabled) {
        this.addInterfaceButton.setEnabled(enabled);
        this.addCallbackInterfaceButton.setEnabled(enabled);
        this.interfaceText.setEnabled(enabled);
        this.callBackInterfaceText.setEnabled(enabled);
    }

    public void refresh() {
        this.removeTextListeners();
        this.removeComboListeners();
        this.interfaceText.setText("");
        this.callBackInterfaceText.setText("");
        this.selectComboItem(this.interfaceTypeCombo, "");
        Interface o = this.getInterface(this.inputObjects.get(0));
        if (o == null) {
            this.enableControls(false);
        } else {
            String label = this.util.getInterfaceLabel(o);
            this.selectComboItem(this.interfaceTypeCombo, label);
            this.enableControls(!label.equals(""));
            String interfaceString = this.util.getInterfaceValue(o);
            String callbackString = this.util.getCallbackInterfaceValue(o);
            if (interfaceString != null) {
                this.interfaceText.setText(interfaceString);
            }
            if (callbackString != null) {
                this.callBackInterfaceText.setText(callbackString);
            }
        }
        this.addComboListeners();
        this.addTextListeners();
    }

    private void addTextListeners() {
        this.interfaceText.addListener(16, (Listener)this.textListener);
        this.interfaceText.addListener(2, (Listener)this.textListener);
        this.callBackInterfaceText.addListener(16, (Listener)this.textListener);
        this.callBackInterfaceText.addListener(2, (Listener)this.textListener);
    }

    private void removeTextListeners() {
        this.interfaceText.removeListener(16, (Listener)this.textListener);
        this.interfaceText.removeListener(2, (Listener)this.textListener);
        this.callBackInterfaceText.removeListener(16, (Listener)this.textListener);
        this.callBackInterfaceText.removeListener(2, (Listener)this.textListener);
    }

    private void addComboListeners() {
        this.interfaceTypeCombo.addSelectionListener((SelectionListener)this.comboListener);
    }

    private void removeComboListeners() {
        this.interfaceTypeCombo.removeSelectionListener((SelectionListener)this.comboListener);
    }

    private IWorkbenchPart getWorkbenchPart() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        return null;
    }

    private class AdapterImplNotifier
    extends AdapterImpl {
        private AdapterImplNotifier() {
        }

        public void notifyChanged(Notification msg) {
            Interface theInterface = SCABaseInterfacePropertySection.this.getInterface(SCABaseInterfacePropertySection.this.inputObjects.get(0));
            if (theInterface != null && !theInterface.eAdapters().contains((Object)SCABaseInterfacePropertySection.this.modelNotifier)) {
                theInterface.eAdapters().add((Object)SCABaseInterfacePropertySection.this.modelNotifier);
            }
            if (!SCABaseInterfacePropertySection.this.interfaceText.isDisposed()) {
                SCABaseInterfacePropertySection.this.refresh();
            }
        }
    }

    private class InterfaceButtonSelectionListener
    extends SelectionAdapter {
        private InterfaceButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == SCABaseInterfacePropertySection.this.addInterfaceButton) {
                String sel = SCABaseInterfacePropertySection.this.interfaceTypeCombo.getItem(SCABaseInterfacePropertySection.this.interfaceTypeCombo.getSelectionIndex());
                Action action = SCABaseInterfacePropertySection.this.util.getAddAndSetInterfaceAction(sel, SCABaseInterfacePropertySection.this.inputObjects.get(0));
                action.run();
            } else if (e.widget == SCABaseInterfacePropertySection.this.addCallbackInterfaceButton) {
                String sel = SCABaseInterfacePropertySection.this.interfaceTypeCombo.getItem(SCABaseInterfacePropertySection.this.interfaceTypeCombo.getSelectionIndex());
                SCALaunchSelectionDialogAction action = SCABaseInterfacePropertySection.this.util.getSelectInterfaceDialogAction(sel);
                action.run();
                String value = action.getSelectionValue();
                Interface interfaze = SCABaseInterfacePropertySection.this.getInterface(SCABaseInterfacePropertySection.this.inputObjects.get(0));
                Action setAction = SCABaseInterfacePropertySection.this.util.getSetCallbackInterfaceValueAction(sel, interfaze, value);
                setAction.run();
            }
        }
    }

    private class InterfaceComboListener
    extends SelectionAdapter {
        private InterfaceComboListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == SCABaseInterfacePropertySection.this.interfaceTypeCombo) {
                String sel = SCABaseInterfacePropertySection.this.interfaceTypeCombo.getItem(SCABaseInterfacePropertySection.this.interfaceTypeCombo.getSelectionIndex());
                if (sel.equals("")) {
                    SCARemoveInterfaceAction action = new SCARemoveInterfaceAction(SCABaseInterfacePropertySection.this.getWorkbenchPart(), SCABaseInterfacePropertySection.this.getInterface(SCABaseInterfacePropertySection.this.inputObjects.get(0)));
                    action.run();
                    SCABaseInterfacePropertySection.this.addInterfaceButton.setEnabled(false);
                    SCABaseInterfacePropertySection.this.addCallbackInterfaceButton.setEnabled(false);
                    SCABaseInterfacePropertySection.this.removeTextListeners();
                    SCABaseInterfacePropertySection.this.interfaceText.setText("");
                    SCABaseInterfacePropertySection.this.callBackInterfaceText.setText("");
                    SCABaseInterfacePropertySection.this.addTextListeners();
                    SCABaseInterfacePropertySection.this.interfaceText.setEnabled(false);
                    SCABaseInterfacePropertySection.this.callBackInterfaceText.setEnabled(false);
                } else {
                    Action addAction = SCABaseInterfacePropertySection.this.util.getAddInterfaceAction(sel, SCABaseInterfacePropertySection.this.inputObjects.get(0));
                    addAction.run();
                    SCABaseInterfacePropertySection.this.removeTextListeners();
                    SCABaseInterfacePropertySection.this.interfaceText.setText("");
                    SCABaseInterfacePropertySection.this.addTextListeners();
                    SCABaseInterfacePropertySection.this.addInterfaceButton.setEnabled(true);
                    SCABaseInterfacePropertySection.this.addCallbackInterfaceButton.setEnabled(true);
                    SCABaseInterfacePropertySection.this.interfaceText.setEnabled(true);
                    SCABaseInterfacePropertySection.this.callBackInterfaceText.setEnabled(true);
                }
            }
        }
    }

    private class SCABaseTextListener
    extends DelayedTextModifyListener {
        private SCABaseTextListener() {
        }

        @Override
        protected void executeHandleEvent(Event event) {
            if (event.widget == SCABaseInterfacePropertySection.this.interfaceText && !SCABaseInterfacePropertySection.this.interfaceText.isDisposed()) {
                String label = SCABaseInterfacePropertySection.this.interfaceTypeCombo.getItem(SCABaseInterfacePropertySection.this.interfaceTypeCombo.getSelectionIndex());
                String text = SCABaseInterfacePropertySection.this.interfaceText.getText();
                Interface interfaze = SCABaseInterfacePropertySection.this.getInterface(SCABaseInterfacePropertySection.this.inputObjects.get(0));
                Action action = SCABaseInterfacePropertySection.this.util.getSetInterfaceValueAction(label, interfaze, text);
                action.run();
            } else if (event.widget == SCABaseInterfacePropertySection.this.callBackInterfaceText && !SCABaseInterfacePropertySection.this.callBackInterfaceText.isDisposed()) {
                String text = SCABaseInterfacePropertySection.this.callBackInterfaceText.getText();
                Interface theInterface = SCABaseInterfacePropertySection.this.getInterface(SCABaseInterfacePropertySection.this.inputObjects.get(0));
                SCAEditInterfaceCallbackAction action = new SCAEditInterfaceCallbackAction(SCABaseInterfacePropertySection.this.getWorkbenchPart(), Messages.SCABaseInterfacePropertySection_19, theInterface, text);
                action.run();
            }
        }
    }
}

