/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.part;

import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.SCAPackage;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class ScaVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(ScaDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Sca".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return ScaVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            ScaDiagramEditorPlugin.traceError(e);
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                ScaDiagramEditorPlugin.getInstance().logError(String.valueOf(Messages.ScaVisualIDRegistry_0) + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (SCAPackage.eINSTANCE.getComposite().isSuperTypeOf(domainElement.eClass()) && ScaVisualIDRegistry.isDiagram((Composite)domainElement)) {
            return 79;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        if (domainElement == null || !"Sca".equals(ScaVisualIDRegistry.getModelID(containerView))) {
            return -1;
        }
        switch (ScaVisualIDRegistry.getVisualID(containerView)) {
            case 5001: {
                if (!SCAPackage.eINSTANCE.getComponentService().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 5002: {
                if (!SCAPackage.eINSTANCE.getComponentReference().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
            case 79: {
                if (SCAPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 1001;
                }
                if (SCAPackage.eINSTANCE.getService().isSuperTypeOf(domainElement.eClass())) {
                    return 1002;
                }
                if (!SCAPackage.eINSTANCE.getReference().isSuperTypeOf(domainElement.eClass())) break;
                return 1003;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = ScaVisualIDRegistry.getModelID(containerView);
        if (!"Sca".equals(containerModelID)) {
            return false;
        }
        if ("Sca".equals(containerModelID)) {
            containerVisualID = ScaVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1001: {
                if (4003 == nodeVisualID) {
                    return true;
                }
                if (10001 == nodeVisualID) {
                    return true;
                }
                if (10002 == nodeVisualID) {
                    return true;
                }
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 1002: {
                if (4004 != nodeVisualID) break;
                return true;
            }
            case 1003: {
                if (4005 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (4001 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (4002 != nodeVisualID) break;
                return true;
            }
            case 5001: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 5002: {
                if (2002 != nodeVisualID) break;
                return true;
            }
            case 79: {
                if (1001 == nodeVisualID) {
                    return true;
                }
                if (1002 == nodeVisualID) {
                    return true;
                }
                if (1003 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(Composite element) {
        return true;
    }
}

