/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.part;

import com.ibm.ccl.sca.composite.emf.sca.provider.SCAItemProviderAdapterFactory;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.attributes.SCAAnyAttributeUIExtensibilityElementFactoryRegistry;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.attributes.SCAAnyAttributeUIExtensibilityElementFactoryRegistryReader;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.SCABindingUIExtensibilityElementFactoryRegistry;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.SCABindingUIExtensibilityElementFactoryRegistryReader;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.SCAImplementationUIExtensibilityElementFactoryRegistry;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.SCAImplementationUIExtensibilityElementFactoryRegistryReader;
import com.ibm.ccl.sca.composite.ui.part.ScaDocumentProvider;
import com.ibm.ccl.sca.core.tracing.SCATrace;
import com.ibm.cic.licensing.common.LicenseCheck;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ScaDiagramEditorPlugin
extends AbstractUIPlugin {
    public static final String ID = "com.ibm.ccl.sca.composite.ui";
    public static final PreferencesHint DIAGRAM_PREFERENCES_HINT = new PreferencesHint("com.ibm.ccl.sca.composite.ui");
    private static ScaDiagramEditorPlugin instance;
    private ComposedAdapterFactory adapterFactory;
    private ScaDocumentProvider documentProvider;
    private static HashMap<URL, RenderedImage> svgMap;
    private SCABindingUIExtensibilityElementFactoryRegistry scaBindingUIExtensibilityElementFactoryRegistry;
    private SCAImplementationUIExtensibilityElementFactoryRegistry scaImplementationUIExtensibilityElementFactoryRegistry;
    private SCAAnyAttributeUIExtensibilityElementFactoryRegistry scaAnyAttributeUIExtensibilityElementFactoryRegistry;

    static {
        svgMap = new HashMap();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        LicenseCheck.requestLicense((Plugin)this, (String)"com.ibm.ccl.sca", (String)"1.0.0");
        instance = this;
        PreferencesHint.registerPreferenceStore((PreferencesHint)DIAGRAM_PREFERENCES_HINT, (Object)this.getPreferenceStore());
        this.adapterFactory = this.createAdapterFactory();
    }

    public void stop(BundleContext context) throws Exception {
        this.adapterFactory.dispose();
        this.adapterFactory = null;
        instance = null;
        super.stop(context);
    }

    public static ScaDiagramEditorPlugin getInstance() {
        return instance;
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ArrayList factories = new ArrayList();
        this.fillItemProviderFactories(factories);
        return new MyComposedAdapterFactory(factories);
    }

    protected void fillItemProviderFactories(List factories) {
        factories.add(new SCAItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
    }

    public AdapterFactory getItemProvidersAdapterFactory() {
        return this.adapterFactory;
    }

    public ImageDescriptor getItemImageDescriptor(Object item) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(item, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage(item));
        }
        return null;
    }

    public Image getImage(String iconName) {
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(iconName);
        if (image == null) {
            imageRegistry.put(iconName, ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)iconName));
            image = imageRegistry.get(iconName);
        }
        return image;
    }

    public static RenderedImage getScalableImage(String pathString) {
        URL url = FileLocator.find((Bundle)ScaDiagramEditorPlugin.getInstance().getBundle(), (IPath)new Path(pathString), null);
        RenderedImage renderedImage = svgMap.get(url);
        if (renderedImage == null) {
            renderedImage = RenderedImageFactory.getInstance((URL)url);
            svgMap.put(url, renderedImage);
        }
        return renderedImage;
    }

    public static ImageDescriptor getBundledImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static ImageDescriptor findImageDescriptor(String path) {
        Path p = new Path(path);
        if (p.isAbsolute() && p.segmentCount() > 1) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)p.segment(0), (String)p.removeFirstSegments(1).makeAbsolute().toString());
        }
        return ScaDiagramEditorPlugin.getBundledImageDescriptor(p.makeAbsolute().toString());
    }

    public Image getBundledImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            this.getImageRegistry().put(path, ScaDiagramEditorPlugin.getBundledImageDescriptor(path));
            image = this.getImageRegistry().get(path);
        }
        return image;
    }

    public static String getString(String key) {
        return Platform.getResourceString((Bundle)ScaDiagramEditorPlugin.getInstance().getBundle(), (String)("%" + key));
    }

    public ScaDocumentProvider getDocumentProvider() {
        if (this.documentProvider == null) {
            this.documentProvider = new ScaDocumentProvider();
        }
        return this.documentProvider;
    }

    public void logError(String error) {
        this.logError(error, null);
    }

    public void logError(String error, Throwable throwable) {
        if (error == null && throwable != null) {
            error = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(4, ID, 0, error, throwable));
        this.debug(error, throwable);
    }

    public void logInfo(String message) {
        this.logInfo(message, null);
    }

    public void logInfo(String message, Throwable throwable) {
        if (message == null && throwable != null) {
            message = throwable.getMessage();
        }
        this.getLog().log((IStatus)new Status(1, ID, 0, message, throwable));
        this.debug(message, throwable);
    }

    private void debug(String message, Throwable throwable) {
        if (!this.isDebugging()) {
            return;
        }
        if (message != null) {
            System.err.println(message);
        }
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static Shell getShell() {
        return ScaDiagramEditorPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public SCABindingUIExtensibilityElementFactoryRegistry getSCABindingUIExtensibilityElementProviderRegistry() {
        if (this.scaBindingUIExtensibilityElementFactoryRegistry == null) {
            this.scaBindingUIExtensibilityElementFactoryRegistry = new SCABindingUIExtensibilityElementFactoryRegistry();
            new SCABindingUIExtensibilityElementFactoryRegistryReader(this.scaBindingUIExtensibilityElementFactoryRegistry).readRegistry();
        }
        return this.scaBindingUIExtensibilityElementFactoryRegistry;
    }

    public SCAImplementationUIExtensibilityElementFactoryRegistry getSCAImplementationUIExtensibilityElementProviderRegistry() {
        if (this.scaImplementationUIExtensibilityElementFactoryRegistry == null) {
            this.scaImplementationUIExtensibilityElementFactoryRegistry = new SCAImplementationUIExtensibilityElementFactoryRegistry();
            new SCAImplementationUIExtensibilityElementFactoryRegistryReader(this.scaImplementationUIExtensibilityElementFactoryRegistry).readRegistry();
        }
        return this.scaImplementationUIExtensibilityElementFactoryRegistry;
    }

    public SCAAnyAttributeUIExtensibilityElementFactoryRegistry getSCAAnyAttributeUIExtensibilityElementProviderRegistry() {
        if (this.scaAnyAttributeUIExtensibilityElementFactoryRegistry == null) {
            this.scaAnyAttributeUIExtensibilityElementFactoryRegistry = new SCAAnyAttributeUIExtensibilityElementFactoryRegistry();
            new SCAAnyAttributeUIExtensibilityElementFactoryRegistryReader(this.scaAnyAttributeUIExtensibilityElementFactoryRegistry).readRegistry();
        }
        return this.scaAnyAttributeUIExtensibilityElementFactoryRegistry;
    }

    public static void traceError(Exception exc) {
        SCATrace.trace((Plugin)instance, (String)"composite_editor", (int)0, (Throwable)exc);
    }

    public static void traceInfo(String message) {
        SCATrace.trace((Plugin)instance, (String)"composite_editor", (int)2, (String)message);
    }

    public class MyComposedAdapterFactory
    extends ComposedAdapterFactory {
        public MyComposedAdapterFactory(Collection<? extends AdapterFactory> adapterFactories) {
            super(adapterFactories);
        }

        public void dispose() {
            super.dispose();
            this.changeNotifier.clear();
        }
    }
}

