/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.part;

import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.impl.DocumentRootImpl;
import com.ibm.ccl.sca.composite.ui.CompositeEditorContextIDs;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCAOpenInEditorAction;
import com.ibm.ccl.sca.composite.ui.custom.actions.ToggleShowBindingIndicatorAction;
import com.ibm.ccl.sca.composite.ui.custom.layout.SCAConnectionLayerEx;
import com.ibm.ccl.sca.composite.ui.custom.part.ScaInitDiagramFileCommand;
import com.ibm.ccl.sca.composite.ui.custom.providers.SCAContextMenuProvider;
import com.ibm.ccl.sca.composite.ui.custom.util.SCALayerManager;
import com.ibm.ccl.sca.composite.ui.navigator.ScaNavigatorItem;
import com.ibm.ccl.sca.composite.ui.part.NoOpTransferDropTargetListener;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramGraphicalViewerKeyHandler;
import com.ibm.ccl.sca.composite.ui.part.ScaPaletteFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.ui.services.marker.MarkerNavigationService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.internal.parts.DirectEditKeyHandler;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;

public class ScaDiagramEditor
extends DiagramDocumentEditor
implements IGotoMarker {
    public static final String ID = "org.osoa.xmlns.sca._1.diagram.part.ScaDiagramEditorID";
    public static final String CONTEXT_ID = "org.osoa.xmlns.sca._1.diagram.ui.diagramContext";
    private SCALayerManager layerManager;

    public void doSave(IProgressMonitor progressMonitor) {
        SetRequest request = new SetRequest(this.getEditingDomain(), null, null, null);
        EditElementCommand saveCommand = new EditElementCommand("", null, (IEditCommandRequest)request){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                ScaDiagramEditor.super.doSave(monitor);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            saveCommand.execute(progressMonitor, null);
        }
        catch (Exception exc) {
            ScaDiagramEditorPlugin.traceError(exc);
        }
    }

    public ScaDiagramEditor() {
        super(true);
    }

    protected String getContextID() {
        return CONTEXT_ID;
    }

    protected PaletteRoot createPaletteRoot(PaletteRoot existingPaletteRoot) {
        PaletteRoot root = super.createPaletteRoot(existingPaletteRoot);
        new ScaPaletteFactory().fillPalette(root);
        return root;
    }

    protected PreferencesHint getPreferencesHint() {
        return ScaDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }

    public String getContributorId() {
        return "com.ibm.ccl.sca.composite.ui";
    }

    public Object getAdapter(Class type) {
        if (type == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
                }
            };
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == SCALayerManager.class) {
            if (this.layerManager == null) {
                this.layerManager = new SCALayerManager(this.getGraphicalViewer());
            }
            return this.layerManager;
        }
        return super.getAdapter(type);
    }

    protected IDocumentProvider getDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput) {
            return ScaDiagramEditorPlugin.getInstance().getDocumentProvider();
        }
        return super.getDocumentProvider(input);
    }

    public TransactionalEditingDomain getEditingDomain() {
        IDocument document;
        IDocument iDocument = document = this.getEditorInput() != null ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()) : null;
        if (document instanceof IDiagramDocument) {
            return ((IDiagramDocument)document).getEditingDomain();
        }
        return super.getEditingDomain();
    }

    protected void setDocumentProvider(IEditorInput input) {
        if (input instanceof IFileEditorInput || input instanceof URIEditorInput) {
            this.setDocumentProvider((IDocumentProvider)ScaDiagramEditorPlugin.getInstance().getDocumentProvider());
        } else {
            super.setDocumentProvider(input);
        }
    }

    public void gotoMarker(IMarker marker) {
        MarkerNavigationService.getInstance().gotoMarker((IEditorPart)this, marker);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block19: {
            IDocumentProvider provider;
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            if ((provider = this.getDocumentProvider()) == null) {
                return;
            }
            dialog.create();
            if (provider.isDeleted((Object)input) && original != null) {
                String message = NLS.bind((String)Messages.ScaDiagramEditor_SavingDeletedFile, (Object)original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
            IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                if (matchingStrategy.matches(editorRefs[i], (IEditorInput)newInput)) {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.ScaDiagramEditor_SaveAsErrorTitle, (String)Messages.ScaDiagramEditor_SaveAsErrorMessage);
                    return;
                }
                ++i;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    this.getDocumentProvider((IEditorInput)newInput).saveDocument(progressMonitor, (Object)newInput, this.getDocumentProvider().getDocument((Object)this.getEditorInput()), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        ErrorDialog.openError((Shell)shell, (String)Messages.ScaDiagramEditor_SaveErrorTitle, (String)Messages.ScaDiagramEditor_SaveErrorMessage, (IStatus)x.getStatus());
                        ScaDiagramEditorPlugin.traceError((Exception)((Object)x));
                    }
                    provider.changed((Object)newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.getEditorInput(), this.getNavigatorSelection());
    }

    private ISelection getNavigatorSelection() {
        IDiagramDocument document = this.getDiagramDocument();
        if (document == null) {
            return StructuredSelection.EMPTY;
        }
        Diagram diagram = document.getDiagram();
        IFile file = WorkspaceSynchronizer.getFile((Resource)diagram.eResource());
        if (file != null) {
            ScaNavigatorItem item = new ScaNavigatorItem((View)diagram, file, false);
            return new StructuredSelection((Object)item);
        }
        return StructuredSelection.EMPTY;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IResource resourceInput;
        IPath path;
        String extension;
        IEditorInput editorInput = input;
        Object resourceObject = input.getAdapter(IResource.class);
        if (resourceObject instanceof IResource && "composite".equals(extension = (path = (resourceInput = (IResource)resourceObject).getFullPath()).getFileExtension())) {
            IPath diagramFilePath = path.removeFileExtension().addFileExtension("composite_diagram");
            IFile diagramFile = ResourcesPlugin.getWorkspace().getRoot().getFile(diagramFilePath);
            if (diagramFile != null && diagramFile.exists()) {
                editorInput = new FileEditorInput(diagramFile);
            } else {
                URI domainModelURI = URI.createPlatformResourceURI((String)path.toString(), (boolean)false);
                TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
                try {
                    ResourceSet resourceSet = editingDomain.getResourceSet();
                    Resource resource = resourceSet.getResource(domainModelURI, true);
                    EObject modelRoot = (EObject)resource.getContents().get(0);
                    if (modelRoot instanceof DocumentRootImpl) {
                        Composite composite = ((DocumentRootImpl)modelRoot).getComposite();
                        ScaInitDiagramFileCommand command = new ScaInitDiagramFileCommand(diagramFile, editingDomain, (EObject)composite);
                        command.run();
                        diagramFile = ResourcesPlugin.getWorkspace().getRoot().getFile(diagramFilePath);
                        if (diagramFile != null && diagramFile.exists()) {
                            editorInput = new FileEditorInput(diagramFile);
                        }
                    }
                }
                finally {
                    editingDomain.dispose();
                }
            }
        }
        super.init(site, editorInput);
    }

    public void createPartControl(org.eclipse.swt.widgets.Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ccl.sca.composite.ui." + CompositeEditorContextIDs.INFOPOP_CANVAS);
        if (this.getDocumentProvider().canSaveDocument((Object)this.getEditorInput())) {
            this.saveDiagramFile();
        }
    }

    public void saveDiagramFile() {
        try {
            this.getDocumentProvider().saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)this.getEditorInput(), (IDocument)this.getDiagramDocument(), true);
        }
        catch (CoreException e) {
            ScaDiagramEditorPlugin.getInstance().getLog().log(e.getStatus());
            ScaDiagramEditorPlugin.traceError((Exception)((Object)e));
        }
    }

    protected void configureGraphicalViewer() {
        RenderedDiagramRootEditPart diagramEP;
        IFigure printableLayer;
        super.configureGraphicalViewer();
        RootEditPart rootEP = this.getDiagramGraphicalViewer().getRootEditPart();
        if (rootEP instanceof RenderedDiagramRootEditPart && (printableLayer = (diagramEP = (RenderedDiagramRootEditPart)rootEP).getLayer((Object)"Printable Layers")) instanceof FreeformLayeredPane) {
            FreeformLayeredPane pane = (FreeformLayeredPane)printableLayer;
            Layer connLayer = pane.getLayer((Object)"Connection Layer");
            pane.removeLayer((IFigure)connLayer);
            pane.addLayerAfter((Layer)new SCAConnectionLayerEx(), (Object)"Connection Layer", (Object)"Primary Layer");
        }
        SCAContextMenuProvider contextMenu = new SCAContextMenuProvider((IWorkbenchPart)this, (EditPartViewer)this.getDiagramGraphicalViewer());
        this.getDiagramGraphicalViewer().setContextMenu((MenuManager)contextMenu);
        IDiagramGraphicalViewer viewer = this.getDiagramGraphicalViewer();
        KeyHandler viewerKeyHandler = new ScaDiagramGraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getKeyHandler());
        viewer.setKeyHandler(new DirectEditKeyHandler((GraphicalViewer)viewer).setParent(viewerKeyHandler));
        viewer.addDropTargetListener((TransferDropTargetListener)new NoOpTransferDropTargetListener((EditPartViewer)viewer));
    }

    public void dispose() {
        AdapterFactory adapterFactory;
        TransactionalEditingDomain ted = this.getEditingDomain();
        super.dispose();
        if (((TransactionalEditingDomainImpl)ted).getChangeRecorder() != null) {
            ted.dispose();
        }
        if ((adapterFactory = ScaDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()) instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)adapterFactory).dispose();
        }
    }

    protected KeyHandler getKeyHandler() {
        KeyHandler handler = super.getKeyHandler();
        ActionRegistry registry = this.getActionRegistry();
        SelectionAction action = new SCAOpenInEditorAction((IWorkbenchPart)this);
        action.setText(Messages.ScaDiagramEditor_2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        handler.put(KeyStroke.getPressed((int)0x100000C, (int)0), (IAction)action);
        action = new ToggleShowBindingIndicatorAction((IWorkbenchPart)this);
        action.setText(Messages.ScaDiagramEditor_3);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        handler.put(KeyStroke.getPressed((int)0x1000014, (int)0), (IAction)action);
        return handler;
    }
}

