/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.navigator;

import com.ibm.ccl.sca.composite.ui.navigator.ScaAbstractNavigatorItem;
import com.ibm.ccl.sca.composite.ui.navigator.ScaNavigatorGroup;
import com.ibm.ccl.sca.composite.ui.navigator.ScaNavigatorItem;
import com.ibm.ccl.sca.composite.ui.part.ScaVisualIDRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class ScaNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public ScaNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "Sca"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof ScaNavigatorGroup) {
            ScaNavigatorGroup group = (ScaNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof ScaNavigatorItem) {
            ScaNavigatorItem navigatorItem = (ScaNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (ScaVisualIDRegistry.getVisualID(view)) {
            case 79: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 1001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 1002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 1003);
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3010);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 1001: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5001);
                connectedViews = this.getChildrenByType(connectedViews, 2001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5002);
                connectedViews = this.getChildrenByType(connectedViews, 2002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getChildrenByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Sca".equals(ScaVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<ScaNavigatorItem> result = new ArrayList<ScaNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new ScaNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof ScaAbstractNavigatorItem) {
            ScaAbstractNavigatorItem abstractNavigatorItem = (ScaAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

