/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.util;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.ComponentService;
import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.custom.promote.EditPromoteCommand;
import com.ibm.ccl.sca.composite.ui.custom.target.EditTargetCommand;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public class RefactorUtils {
    public static void refactorComponentRefName(ComponentReference ref, String oldName, String newName, CompositeCommand mainCommand) {
        Composite composite = (Composite)ref.eContainer().eContainer();
        String fullName = RefactorUtils.getFullName((EObject)ref);
        for (Reference reference : composite.getReference()) {
            List promoteList = reference.getPromote();
            List<String> newList = null;
            newList = RefactorUtils.changeAllInList("(.*)/" + oldName + "$", "$1/" + newName, fullName, null, promoteList);
            if (newList == null) continue;
            SetRequest request = new SetRequest((EObject)reference, null, newList);
            EditPromoteCommand promoteCmd = new EditPromoteCommand(request, false);
            mainCommand.add((IUndoableOperation)promoteCmd);
        }
    }

    public static void refactorComponentServiceName(ComponentService compService, String oldName, String newName, CompositeCommand mainCommand) {
        SetRequest request;
        List<String> newList;
        Composite composite = (Composite)compService.eContainer().eContainer();
        String fullName = RefactorUtils.getFullName((EObject)compService);
        for (Service service : composite.getService()) {
            String promote = service.getPromote();
            if (promote == null) continue;
            ArrayList<String> promoteList = new ArrayList<String>(1);
            promoteList.add(promote);
            newList = RefactorUtils.changeAllInList("(.*)/" + oldName + "$", "$1/" + newName, fullName, null, promoteList);
            if (newList == null) continue;
            request = new SetRequest((EObject)service, null, newList);
            EditPromoteCommand promoteCmd = new EditPromoteCommand(request, true);
            mainCommand.add((IUndoableOperation)promoteCmd);
        }
        for (Reference reference : composite.getReference()) {
            List targetList = reference.getTarget();
            List<String> newList2 = null;
            newList2 = RefactorUtils.changeAllInList("(.*)/" + oldName + "$", "$1/" + newName, fullName, null, targetList);
            if (newList2 == null) continue;
            SetRequest request2 = new SetRequest((EObject)reference, null, newList2);
            EditTargetCommand targetCmd = new EditTargetCommand(request2);
            mainCommand.add((IUndoableOperation)targetCmd);
        }
        for (Component comp : composite.getComponent()) {
            for (ComponentReference ref : comp.getReference()) {
                newList = RefactorUtils.changeAllInList("(.*)/" + oldName + "$", "$1/" + newName, fullName, null, ref.getTarget());
                if (newList == null) continue;
                request = new SetRequest((EObject)ref, null, newList);
                EditTargetCommand targetCmd = new EditTargetCommand(request);
                mainCommand.add((IUndoableOperation)targetCmd);
            }
        }
    }

    public static void refactorComponentName(Component component, String oldName, String newName, CompositeCommand mainCommand) {
        EditTargetCommand targetCmd;
        EditPromoteCommand promoteCmd;
        SetRequest request;
        List<String> newList;
        Composite composite = (Composite)component.eContainer();
        for (Service service : composite.getService()) {
            String promote = service.getPromote();
            if (promote == null) continue;
            ArrayList<String> promoteList = new ArrayList<String>(1);
            promoteList.add(promote);
            newList = RefactorUtils.changeAllInList("^" + oldName + "/(.*)", String.valueOf(newName) + "/$1", oldName, newName, promoteList);
            if (newList == null) continue;
            request = new SetRequest((EObject)service, null, newList);
            promoteCmd = new EditPromoteCommand(request, true);
            mainCommand.add((IUndoableOperation)promoteCmd);
        }
        for (Reference reference : composite.getReference()) {
            List promoteList = reference.getPromote();
            List targetList = reference.getTarget();
            newList = null;
            newList = RefactorUtils.changeAllInList("^" + oldName + "/(.*)", String.valueOf(newName) + "/$1", oldName, newName, promoteList);
            if (newList != null) {
                request = new SetRequest((EObject)reference, null, newList);
                promoteCmd = new EditPromoteCommand(request, false);
                mainCommand.add((IUndoableOperation)promoteCmd);
            }
            if ((newList = RefactorUtils.changeAllInList("^" + oldName + "/(.*)", String.valueOf(newName) + "/$1", oldName, newName, targetList)) == null) continue;
            request = new SetRequest((EObject)reference, null, newList);
            targetCmd = new EditTargetCommand(request);
            mainCommand.add((IUndoableOperation)targetCmd);
        }
        for (Component comp : composite.getComponent()) {
            for (ComponentReference ref : comp.getReference()) {
                newList = RefactorUtils.changeAllInList("^" + oldName + "/(.*)", String.valueOf(newName) + "/$1", oldName, newName, ref.getTarget());
                if (newList == null) continue;
                request = new SetRequest((EObject)ref, null, newList);
                targetCmd = new EditTargetCommand(request);
                mainCommand.add((IUndoableOperation)targetCmd);
            }
        }
    }

    private static List<String> changeAllInList(String oldPattern, String newPattern, String oldName, String newName, List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> newList = new ArrayList<String>(list.size());
        boolean valueChanged = false;
        for (String value : list) {
            int slashIndex = value.indexOf(47);
            String newValue = value;
            if (slashIndex == -1 && oldName != null && oldName.equals(value)) {
                newValue = newName;
                valueChanged = true;
            } else if ((slashIndex != -1 && newName != null || newName == null && oldName.equals(value)) && !(newValue = value.replaceAll(oldPattern, newPattern)).equals(value)) {
                valueChanged = true;
            }
            newList.add(newValue);
        }
        return valueChanged ? newList : null;
    }

    private static String getFullName(EObject object) {
        Component component = (Component)object.eContainer();
        String fullName = null;
        if (object instanceof ComponentReference) {
            fullName = String.valueOf(component.getName()) + "/" + ((ComponentReference)object).getName();
        } else if (object instanceof ComponentService) {
            fullName = String.valueOf(component.getName()) + "/" + ((ComponentService)object).getName();
        }
        return fullName;
    }
}

