/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.layout;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentGroupingFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentReferenceGroupingFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentServiceGroupingFigure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;

public final class SCAManhattanConnectionRouter
extends AbstractRouter {
    private Map<Integer, Integer> rowsUsed = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> colsUsed = new HashMap<Integer, Integer>();
    private Map<Connection, Object> constraints = new HashMap<Connection, Object>();
    private Map<Connection, ReservedInfo> reservedInfo = new HashMap<Connection, ReservedInfo>();
    private LayeredPane parent;
    private static Ray UP = new Ray(0, -1);
    private static Ray DOWN = new Ray(0, 1);
    private static Ray LEFT = new Ray(-1, 0);
    private static Ray RIGHT = new Ray(1, 0);

    public SCAManhattanConnectionRouter(LayeredPane parent) {
        this.parent = parent;
    }

    public void invalidate(Connection connection) {
        this.removeReservedLines(connection);
    }

    private int getColumnNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 6 != 0) {
            r -= r % 6;
        }
        while (proximity < r) {
            Integer i = new Integer(r + proximity * direction);
            if (!this.colsUsed.containsKey(i)) {
                this.colsUsed.put(i, i);
                this.reserveColumn(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 6;
            }
            if (j >= max) {
                return j - 6;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 6;
        }
        return r;
    }

    protected Ray getDirection(Rectangle r, Point p) {
        int distance = Math.abs(r.x - p.x);
        Ray direction = LEFT;
        int i = Math.abs(r.y - p.y);
        if (i <= distance) {
            distance = i;
            direction = UP;
        }
        if ((i = Math.abs(r.right() - p.x)) < distance) {
            distance = i;
            direction = RIGHT;
        }
        return direction;
    }

    protected Ray getEndDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getTargetAnchor();
        Point p = this.getEndPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x, p.y - 1, 2, 2);
        } else {
            rect = conn.getTargetAnchor().getOwner().getBounds().getCopy();
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)rect);
        }
        return this.getDirection(rect, p);
    }

    protected int getRowNear(Connection connection, int r, int n, int x) {
        int min = Math.min(n, x);
        int max = Math.max(n, x);
        if (min > r) {
            max = min;
            min = r - (min - r);
        }
        if (max < r) {
            min = max;
            max = r + (r - max);
        }
        int proximity = 0;
        int direction = -1;
        if (r % 6 != 0) {
            r -= r % 6;
        }
        while (proximity < r) {
            Integer i = new Integer(r + proximity * direction);
            if (!this.rowsUsed.containsKey(i)) {
                this.rowsUsed.put(i, i);
                this.reserveRow(connection, i);
                return i;
            }
            int j = i;
            if (j <= min) {
                return j + 6;
            }
            if (j >= max) {
                return j - 6;
            }
            if (direction == 1) {
                direction = -1;
                continue;
            }
            direction = 1;
            proximity += 6;
        }
        return r;
    }

    protected Ray getStartDirection(Connection conn) {
        Rectangle rect;
        ConnectionAnchor anchor = conn.getSourceAnchor();
        Point p = this.getStartPoint(conn);
        if (anchor.getOwner() == null) {
            rect = new Rectangle(p.x - 1, p.y - 1, 2, 2);
        } else {
            rect = conn.getSourceAnchor().getOwner().getBounds().getCopy();
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)rect);
        }
        return this.getDirection(rect, p);
    }

    protected void processPositions(Ray start, Ray end, List positions, boolean horizontal, Connection conn) {
        this.removeReservedLines(conn);
        int[] pos = new int[positions.size() + 2];
        pos[0] = horizontal ? start.x : start.y;
        int i = 0;
        while (i < positions.size()) {
            pos[i + 1] = (Integer)positions.get(i);
            ++i;
        }
        pos[++i] = horizontal == (positions.size() % 2 == 1) ? end.x : end.y;
        PointList points = new PointList();
        points.addPoint(new Point(start.x, start.y));
        i = 2;
        while (i < pos.length - 1) {
            Point p;
            int max;
            int min;
            boolean adjust;
            horizontal = !horizontal;
            int prev = pos[i - 1];
            int current = pos[i];
            boolean bl = adjust = i != pos.length - 2;
            if (horizontal) {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getRowNear(conn, current, min, max);
                }
                p = new Point(prev, current);
            } else {
                if (adjust) {
                    min = pos[i - 2];
                    max = pos[i + 2];
                    pos[i] = current = this.getColumnNear(conn, current, min, max);
                }
                p = new Point(current, prev);
            }
            points.addPoint(p);
            ++i;
        }
        points.addPoint(new Point(end.x, end.y));
        conn.setPoints(points);
    }

    public void remove(Connection connection) {
        this.removeReservedLines(connection);
    }

    protected void removeReservedLines(Connection connection) {
        ReservedInfo rInfo = this.reservedInfo.get(connection);
        if (rInfo == null) {
            return;
        }
        int i = 0;
        while (i < rInfo.reservedRows.size()) {
            this.rowsUsed.remove(rInfo.reservedRows.get(i));
            ++i;
        }
        i = 0;
        while (i < rInfo.reservedCols.size()) {
            this.colsUsed.remove(rInfo.reservedCols.get(i));
            ++i;
        }
        this.reservedInfo.remove(connection);
    }

    protected void reserveColumn(Connection connection, Integer column) {
        ReservedInfo info = this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedCols.add(column);
    }

    protected void reserveRow(Connection connection, Integer row) {
        ReservedInfo info = this.reservedInfo.get(connection);
        if (info == null) {
            info = new ReservedInfo();
            this.reservedInfo.put(connection, info);
        }
        info.reservedRows.add(row);
    }

    public void route(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        Point startPoint = this.getStartPoint(conn);
        conn.translateToRelative((Translatable)startPoint);
        Point endPoint = this.getEndPoint(conn);
        conn.translateToRelative((Translatable)endPoint);
        Ray start = new Ray(startPoint);
        Ray end = new Ray(endPoint);
        Ray average = start.getAveraged(end);
        Ray direction = new Ray(start, end);
        Ray startNormal = this.getStartDirection(conn);
        Ray endNormal = this.getEndDirection(conn);
        ArrayList<Integer> positions = new ArrayList<Integer>(5);
        boolean horizontal = startNormal.isHorizontal();
        if (horizontal) {
            positions.add(new Integer(start.y));
        } else {
            positions.add(new Integer(start.x));
        }
        boolean bl = horizontal = !horizontal;
        if (startNormal.dotProduct(endNormal) == 0) {
            if (startNormal.dotProduct(direction) < 0 || endNormal.dotProduct(direction) > 0) {
                int i = startNormal.dotProduct(direction) < 0 ? startNormal.similarity(start.getAdded(startNormal.getScaled(10))) : (horizontal ? average.y : average.x);
                positions.add(new Integer(i));
                boolean bl2 = horizontal = !horizontal;
                i = endNormal.dotProduct(direction) > 0 ? endNormal.similarity(end.getAdded(endNormal.getScaled(10))) : (horizontal ? average.y : average.x);
                positions.add(new Integer(i));
                horizontal = !horizontal;
            }
        } else if (startNormal.dotProduct(endNormal) > 0) {
            int i = startNormal.dotProduct(direction) >= 0 ? startNormal.similarity(start.getAdded(startNormal.getScaled(10))) : endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
            positions.add(new Integer(i));
            horizontal = !horizontal;
        } else {
            int i;
            if (startNormal.dotProduct(direction) < 0) {
                i = startNormal.similarity(start.getAdded(startNormal.getScaled(10)));
                positions.add(new Integer(i));
                boolean bl3 = horizontal = !horizontal;
            }
            if (this.isCycle(conn)) {
                i = horizontal ? conn.getSourceAnchor().getOwner().getBounds().getTop().y - 10 : conn.getSourceAnchor().getOwner().getBounds().getRight().x + 10;
            } else if (horizontal) {
                int j = average.y;
                int next = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
                Ray trial = new Ray(((Integer)positions.get(positions.size() - 1)).intValue(), j);
                IFigure figure = this.findFirstFigureAtStraightLine(trial, LEFT, Collections.EMPTY_LIST);
                while (figure != null && figure.getBounds().x + figure.getBounds().width > next) {
                    trial.y = j = figure.getBounds().y + figure.getBounds().height + 5;
                    figure = this.findFirstFigureAtStraightLine(trial, LEFT, Collections.EMPTY_LIST);
                }
                i = j;
            } else {
                IFigure figure = this.findFirstFigureAtStraightLine(start, RIGHT, this.getExcludingFigures(conn));
                if (figure == null) {
                    i = average.x;
                } else {
                    i = Math.min(average.x, start.getAdded((Ray)new Ray((int)(3 * (figure.getBounds().x - start.x) / 4), (int)0)).x);
                    i = Math.max(start.x, i);
                }
                i = this.adjust(conn, i);
            }
            positions.add(new Integer(i));
            boolean bl4 = horizontal = !horizontal;
            if (startNormal.dotProduct(direction) < 0) {
                i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
                positions.add(new Integer(i));
                horizontal = !horizontal;
            } else {
                boolean reroute = false;
                int j = end.y;
                IFigure figure = this.findFirstFigureAtStraightLine(new Ray(i, j), RIGHT, this.getExcludingFigures(conn));
                while (figure != null && figure.getBounds().x < end.x) {
                    reroute = true;
                    j = direction.dotProduct(DOWN) > 0 ? figure.getBounds().y - 5 : figure.getBounds().y + figure.getBounds().height + 5;
                    figure = this.findFirstFigureAtStraightLine(new Ray(i, j), RIGHT, this.getExcludingFigures(conn));
                }
                if (reroute) {
                    i = j;
                    positions.add(new Integer(i));
                    horizontal = !horizontal;
                    i = endNormal.similarity(end.getAdded(endNormal.getScaled(10)));
                    positions.add(new Integer(i));
                    boolean bl5 = horizontal = !horizontal;
                }
            }
        }
        if (horizontal) {
            positions.add(new Integer(end.y));
        } else {
            positions.add(new Integer(end.x));
        }
        this.processPositions(start, end, positions, startNormal.isHorizontal(), conn);
    }

    public Object getConstraint(Connection connection) {
        return this.constraints.get(connection);
    }

    public void setConstraint(Connection connection, Object constraint) {
        this.constraints.put(connection, constraint);
    }

    protected boolean isCycle(Connection conn) {
        IFigure source = conn.getSourceAnchor().getOwner();
        IFigure target = conn.getTargetAnchor().getOwner();
        return source != null && source.equals(target);
    }

    protected List getExcludingFigures(Connection conn) {
        ArrayList<IFigure> excluding = new ArrayList<IFigure>();
        excluding.add(conn.getSourceAnchor().getOwner());
        excluding.add(conn.getTargetAnchor().getOwner());
        return excluding;
    }

    protected IFigure findFirstFigureAtStraightLine(Ray start, Ray direction, List excluding) {
        IFigure figure = null;
        List figures = this.getNodeFigures();
        int i = 0;
        while (i < figures.size()) {
            IFigure child = (IFigure)figures.get(i);
            if (!excluding.contains(child)) {
                Rectangle rect = child.getBounds();
                if (LEFT.equals((Object)direction)) {
                    if (start.x > rect.x && start.y >= rect.y && start.y <= rect.y + rect.height && (figure == null || child.getBounds().x > figure.getBounds().x)) {
                        figure = child;
                    }
                } else if (RIGHT.equals((Object)direction)) {
                    if (start.x < rect.x + rect.width && start.y >= rect.y && start.y <= rect.y + rect.height && (figure == null || child.getBounds().x < figure.getBounds().x)) {
                        figure = child;
                    }
                } else if (UP.equals((Object)direction)) {
                    if (start.y > rect.y && start.x >= rect.x && start.x <= rect.x + rect.width && (figure == null || child.getBounds().y > figure.getBounds().y)) {
                        figure = child;
                    }
                } else if (DOWN.equals((Object)direction) && start.y < rect.y + rect.height && start.x >= rect.x && start.x <= rect.x + rect.width && (figure == null || child.getBounds().y < figure.getBounds().y)) {
                    figure = child;
                }
            }
            ++i;
        }
        return figure;
    }

    protected int adjust(Connection connection, int col) {
        int column = col;
        Point start = connection.getSourceAnchor().getLocation(null);
        List connections = this.getConnectionFigures();
        int i = 0;
        while (i < connections.size()) {
            Connection conn = (Connection)connections.get(i);
            if (!conn.equals(connection)) {
                Point end = conn.getTargetAnchor().getLocation(null);
                if (start.x < end.x && start.y == end.y && conn.getPoints().getMidpoint().x <= col) {
                    column = conn.getPoints().getMidpoint().x - 5;
                }
            }
            ++i;
        }
        return column;
    }

    public IFigure getPrimary() {
        Layer f = this.parent.getLayer((Object)"Primary Layer");
        if (f != null) {
            return (IFigure)f.getChildren().get(0);
        }
        return null;
    }

    private ComponentFigure getComponentFigure(ComponentGroupingFigure fig) {
        for (Object item : fig.getChildren()) {
            if (!(item instanceof ComponentFigure)) continue;
            return (ComponentFigure)((Object)item);
        }
        return null;
    }

    private List getNodeFigures() {
        Layer f = this.parent.getLayer((Object)"Primary Layer");
        if (f != null) {
            ArrayList<ComponentFigure> figures = new ArrayList<ComponentFigure>();
            for (Object item : ((IFigure)f.getChildren().get(0)).getChildren()) {
                if (item instanceof ComponentGroupingFigure) {
                    ComponentFigure fig = this.getComponentFigure((ComponentGroupingFigure)((Object)item));
                    if (fig == null) continue;
                    figures.add(fig);
                    continue;
                }
                if (item instanceof ComponentServiceGroupingFigure || item instanceof ComponentReferenceGroupingFigure) continue;
                figures.add((ComponentFigure)((Object)item));
            }
            return figures;
        }
        return Collections.EMPTY_LIST;
    }

    private List getConnectionFigures() {
        ArrayList conn = new ArrayList();
        Layer f = this.parent.getLayer((Object)"Connection Layer");
        if (f != null) {
            conn.addAll(f.getChildren());
        }
        return conn;
    }

    private class ReservedInfo {
        public List<Integer> reservedRows = new ArrayList<Integer>(2);
        public List<Integer> reservedCols = new ArrayList<Integer>(2);

        private ReservedInfo() {
        }
    }
}

