/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.layout;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ComponentImplementationFigureLayout
extends AbstractLayout {
    private int spacing = 4;

    public void layout(IFigure container) {
        List children = container.getChildren();
        Rectangle componentBounds = container.getBounds();
        if (children.size() > 0) {
            IFigure child = (IFigure)children.get(0);
            Dimension childSize = this.calculateChildSize(child, componentBounds);
            child.setLocation(this.calculateChildLocation(childSize, componentBounds));
            child.setSize(childSize);
        }
    }

    private Point calculateChildLocation(Dimension childSize, Rectangle bounds) {
        int x = bounds.x + (bounds.width / 2 - childSize.width / 2);
        int y = bounds.y + (bounds.height / 2 - childSize.height / 2);
        return new Point(x, y);
    }

    private Dimension calculateChildSize(IFigure child, Rectangle bounds) {
        Dimension preferredSize = child.getPreferredSize();
        int width = preferredSize.width;
        int height = preferredSize.height;
        if (width < bounds.width && height < bounds.height) {
            return new Dimension(width, height);
        }
        if (width >= height) {
            int ratio = width / height;
            width = bounds.width - this.spacing * 2;
            height = width / ratio;
        } else {
            int ratio = height / width;
            height = bounds.height - this.spacing * 2;
            width = height / ratio;
        }
        return new Dimension(width, height);
    }

    public Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        return new Dimension(ComponentRelatedFigureConstants.IMPLEMENTATION_OUTER_FIGURE_WIDTH, ComponentRelatedFigureConstants.IMPLEMENTATION_OUTER_FIGURE_HEIGHT);
    }
}

