/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.layout;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentImplementationFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentReferenceGroupingFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentServiceGroupingFigure;
import com.ibm.ccl.sca.composite.ui.custom.figures.PropertiesComponentFigure;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ComponentGroupingFigureLayout
extends FlowLayout {
    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        List children = container.getChildren();
        int index = 0;
        while (index < children.size()) {
            if (children.get(index) instanceof ComponentFigure) {
                Dimension childDimension = ((IFigure)children.get(index)).getSize();
                int width = childDimension.width + ComponentRelatedFigureConstants.HORIZONTAL_SERVICE_CHEVRON_OVERHANG + ComponentRelatedFigureConstants.HORIZONTAL_REFERENCE_CHEVRON_OVERHANG + ComponentRelatedFigureConstants.COMPONENT_SELECTION_BORDER_WIDTH * 2;
                int height = childDimension.height + ComponentRelatedFigureConstants.COMPONENT_SELECTION_BORDER_WIDTH * 2;
                return new Dimension(width, height);
            }
            ++index;
        }
        Dimension dim = super.getMinimumSize(container, wHint, hHint);
        dim.width += ComponentRelatedFigureConstants.COMPONENT_SELECTION_BORDER_WIDTH * 2;
        dim.height += ComponentRelatedFigureConstants.COMPONENT_SELECTION_BORDER_WIDTH * 2;
        return dim;
    }

    public void layout(IFigure container) {
        IFigure componentFigure = null;
        IFigure propertiesFigure = null;
        IFigure implementationFigure = null;
        ArrayList topFigures = new ArrayList();
        List children = container.getChildren();
        int index = 0;
        while (index < children.size()) {
            if (children.get(index) instanceof ComponentFigure) {
                componentFigure = (IFigure)children.get(index);
            } else if (children.get(index) instanceof ComponentReferenceGroupingFigure || children.get(index) instanceof ComponentServiceGroupingFigure) {
                topFigures.add(children.get(index));
            } else if (children.get(index) instanceof PropertiesComponentFigure) {
                propertiesFigure = (IFigure)children.get(index);
            } else if (children.get(index) instanceof ComponentImplementationFigure) {
                implementationFigure = (IFigure)children.get(index);
            }
            ++index;
        }
        if (componentFigure != null) {
            Rectangle parentBounds = container.getBounds();
            int parentBoundsX = parentBounds.x + ComponentRelatedFigureConstants.HORIZONTAL_SERVICE_CHEVRON_OVERHANG;
            int parentBoundsY = parentBounds.y + ComponentRelatedFigureConstants.COMPONENT_SELECTION_BORDER_WIDTH;
            Rectangle componentBounds = componentFigure.getBounds();
            componentFigure.setBounds(new Rectangle(parentBoundsX, parentBoundsY, componentBounds.width, componentBounds.height));
            Dimension compSize = componentFigure.getPreferredSize();
            componentFigure.setSize(compSize);
            componentBounds = componentFigure.getBounds();
            if (propertiesFigure != null) {
                propertiesFigure.setSize(propertiesFigure.getPreferredSize());
                propertiesFigure.setLocation(this.calculatePropertiesLocation(componentBounds, propertiesFigure));
            }
            if (implementationFigure != null) {
                implementationFigure.setSize(implementationFigure.getPreferredSize());
                implementationFigure.setLocation(this.calculateImplLocation(componentBounds, implementationFigure));
            }
            for (IFigure fig : topFigures) {
                if (fig instanceof ComponentReferenceGroupingFigure) {
                    fig.setSize(fig.getPreferredSize());
                    fig.setLocation(this.calcualteReferenceCompartmentLocation(componentBounds, fig));
                    continue;
                }
                if (!(fig instanceof ComponentServiceGroupingFigure)) continue;
                fig.setSize(fig.getPreferredSize());
                fig.setLocation(this.calcualteServiceCompartmentLocation(componentBounds, fig));
            }
        }
    }

    protected Point calcualteReferenceCompartmentLocation(Rectangle parentBounds, IFigure child) {
        int x = parentBounds.x + parentBounds.width - ComponentRelatedFigureConstants.HORIZONTAL_REFERENCE_CHEVRON_OVERLAP;
        int parentHalfHeight = parentBounds.height / 2;
        int childHalfHeight = child.getSize().height / 2;
        int y = parentBounds.y + (parentHalfHeight - childHalfHeight);
        return new Point(x, y);
    }

    protected Point calcualteServiceCompartmentLocation(Rectangle parentBounds, IFigure child) {
        int x = parentBounds.x - ComponentRelatedFigureConstants.HORIZONTAL_SERVICE_CHEVRON_OVERHANG;
        int parentHalfHeight = parentBounds.height / 2;
        int childHalfHeight = child.getSize().height / 2;
        int y = parentBounds.y + (parentHalfHeight - childHalfHeight);
        return new Point(x, y);
    }

    protected Point calculatePropertiesLocation(Rectangle parentBounds, IFigure child) {
        int x = parentBounds.x + parentBounds.width / 2 - child.getSize().width / 2;
        int y = parentBounds.y;
        return new Point(x, y);
    }

    protected Point calculateImplLocation(Rectangle parentBounds, IFigure child) {
        int x = parentBounds.x + parentBounds.width / 2 - child.getSize().width / 2;
        int y = parentBounds.y + parentBounds.height - child.getSize().height - 2;
        return new Point(x, y);
    }
}

