/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.include;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.Implementation;
import com.ibm.ccl.sca.composite.emf.sca.Include;
import com.ibm.ccl.sca.composite.emf.sca.SCAFactory;
import com.ibm.ccl.sca.composite.emf.sca.SCAImplementation;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.actions.AddRemoveTableAction;
import com.ibm.ccl.sca.composite.ui.custom.include.EditIncludeCommand;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.common.controls.CompositeSelectionControlFactory;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class AddIncludeAction
extends AddRemoveTableAction {
    public AddIncludeAction(IWorkbenchPart part, EObject compositeElement) {
        super(part, compositeElement);
        this.setText(Messages.AddRemoveTableAction_0);
    }

    public void run() {
        ICompositeSelectionDialog selectDialog = CompositeSelectionControlFactory.createCompositeSelectionDialogWithCheckedTree(null);
        selectDialog.setCurrentResource((IResource)this.getCompositeFile(this.part));
        selectDialog.initialize();
        selectDialog.setIgnoredQNames(this.getCurrentCompositeQNames((Composite)this.parent));
        if (((Dialog)selectDialog).open() == 0) {
            List composites = selectDialog.getSelectedComposites();
            SetRequest request = new SetRequest(this.parent, null, this.getNameList((Composite)this.parent, composites));
            EditIncludeCommand command = new EditIncludeCommand(request);
            try {
                command.execute(null, null);
            }
            catch (Exception exc) {
                ScaDiagramEditorPlugin.traceError(exc);
            }
        }
    }

    private List<QName> getCurrentCompositeQNames(Composite composite) {
        ArrayList<QName> qnameList = new ArrayList<QName>();
        EList compIncludes = composite.getInclude();
        for (Include include : compIncludes) {
            QName name = include.getName();
            if (name == null) continue;
            qnameList.add(name);
        }
        String thisCompositeName = composite.getName();
        String thisCompositeNamespace = composite.getTargetNamespace();
        if (thisCompositeName != null && thisCompositeNamespace != null) {
            qnameList.add(new QName(thisCompositeNamespace, thisCompositeName));
        }
        for (Component component : composite.getComponent()) {
            SCAImplementation compositeImpl;
            QName name;
            Implementation impl = component.getImplementation();
            if (!(impl instanceof SCAImplementation) || (name = (compositeImpl = (SCAImplementation)impl).getName()) == null || qnameList.contains(name)) continue;
            qnameList.add(name);
        }
        return qnameList;
    }

    private List<Include> getNameList(Composite composite, List<ISCAComposite> includeComposites) {
        Object name;
        EList compIncludes = composite.getInclude();
        TreeSet<Object> allNames = new TreeSet<Object>();
        ArrayList<Include> newIncludes = new ArrayList<Include>();
        SCAFactory factory = SCAFactory.eINSTANCE;
        for (Include include : compIncludes) {
            name = include.getName();
            if (name == null) continue;
            allNames.add(((QName)name).toString());
            newIncludes.add(include);
        }
        for (ISCAComposite scaComposite : includeComposites) {
            name = scaComposite.getName().toString();
            if (allNames.contains(name)) continue;
            allNames.add(name);
            Include newInclude = factory.createInclude();
            newInclude.setName(scaComposite.getName());
            newIncludes.add(newInclude);
        }
        return newIncludes;
    }

    private IFile getCompositeFile(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            IFile diagramFile = (IFile)input.getAdapter(IFile.class);
            String filename = diagramFile.getName();
            filename = filename.substring(0, filename.length() - 8);
            return diagramFile.getParent().getFile((IPath)new Path(filename));
        }
        return null;
    }
}

