/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.figures;

import com.ibm.ccl.sca.composite.ui.custom.figures.ComponentRelatedFigureConstants;
import com.ibm.ccl.sca.composite.ui.custom.figures.OverlayIndicatorFigureSupport;
import com.ibm.ccl.sca.composite.ui.custom.figures.SelectionAndHoverFeedbackAwareFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public abstract class BaseChevronFigure
extends OverlayIndicatorFigureSupport
implements SelectionAndHoverFeedbackAwareFigure {
    protected Label tooltipLabel;
    protected Color topGradientDarkerColor;
    protected Color topGradientLighterColor;
    protected Color bottomGradientDarkerColor;
    protected Color bottomGradientLighterColor;
    protected Color leftWhiteoutColor;
    protected Color upperRightWhiteoutColor;
    protected Color bottomRightWhiteoutColor;
    protected Color chevronBorderColor = ComponentRelatedFigureConstants.COMPONENT_FOREGROUND_CHEVRON_COLOR;
    IFigure feedback;

    public BaseChevronFigure(Dimension size) {
        super(size);
        this.tooltipLabel = new Label();
    }

    public void setToolTipString(String string) {
        this.tooltipLabel.setText(string);
    }

    protected abstract void drawChevronOutline(Rectangle var1, Graphics var2);

    protected abstract IFigure getChevronFeedbackFigure(Color var1, Color var2);

    protected abstract void whiteoutLeftArea(Rectangle var1, Graphics var2);

    protected abstract void whiteoutUpperRightArea(Rectangle var1, Graphics var2);

    protected abstract void whiteoutBottomRightArea(Rectangle var1, Graphics var2);

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds();
        r = new Rectangle(r.x, r.y, r.width - 1, r.height - 1);
        int componentChevronWidth = this.getBounds().width - 4;
        int componentChevronHeight = this.getBounds().height - 4;
        int componentChevronHalfHeight = componentChevronHeight / 2;
        int gradientX = r.x + 1;
        int gradientY = r.y + 2;
        Rectangle gradientBounds = new Rectangle(gradientX, gradientY, componentChevronWidth, componentChevronHalfHeight + 1);
        g.setForegroundColor(this.topGradientDarkerColor);
        g.setBackgroundColor(this.topGradientLighterColor);
        g.fillGradient(gradientBounds, true);
        int bottomGradientHeight = componentChevronHalfHeight;
        if (componentChevronHeight % 2 != 0) {
            bottomGradientHeight = componentChevronHalfHeight + 1;
        }
        gradientBounds = new Rectangle(gradientX, gradientY + componentChevronHalfHeight, componentChevronWidth, bottomGradientHeight);
        g.setForegroundColor(this.bottomGradientLighterColor);
        g.setBackgroundColor(this.bottomGradientDarkerColor);
        g.fillGradient(gradientBounds, true);
        this.whiteoutLeftArea(r, g);
        this.whiteoutUpperRightArea(r, g);
        this.whiteoutBottomRightArea(r, g);
        this.drawChevronOutline(r, g);
    }

    @Override
    public void showSelectionFeedback() {
        this.removeAllFeedback();
        this.feedback = this.getChevronFeedbackFigure(ComponentRelatedFigureConstants.CHEVRON_SELECTION_OUTER_BORDER_COLOR, ComponentRelatedFigureConstants.CHEVRON_SELECTION_INNER_BORDER_COLOR);
        this.add(this.feedback);
    }

    @Override
    public void showHoverFeedback() {
        this.removeAllFeedback();
        this.feedback = this.getChevronFeedbackFigure(ComponentRelatedFigureConstants.CHEVRON_HOVER_OUTER_BORDER_COLOR, ComponentRelatedFigureConstants.CHEVRON_HOVER_INNER_BORDER_COLOR);
        this.add(this.feedback);
    }

    @Override
    public void removeAllFeedback() {
        if (this.feedback != null) {
            this.remove(this.feedback);
            this.revalidateAndRepaint();
            this.feedback = null;
        }
    }

    private void revalidateAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setHoverTooltipString(String string) {
        if (string == null) {
            this.setToolTip(null);
        } else {
            if (this.getToolTip() == null) {
                this.setToolTip((IFigure)this.tooltipLabel);
            }
            this.tooltipLabel.setText(string);
        }
    }
}

