/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.ComponentImplementationResource;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.IImplementationUIProvider;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.core.plugin.SCAToolsCorePlugin;
import com.ibm.ccl.sca.core.preferences.SCAPreferences;
import com.ibm.ccl.sca.facets.core.impltype.ImplTypeEntry;
import java.util.List;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.osgi.framework.Bundle;

public class SCAImplementationUIExtensibilityElementDescriptor {
    public static String NAMESPACE_AND_NAME_SEPARATOR = "#";
    protected Bundle bundle;
    protected String namespace;
    protected String elementName;
    protected String uiProviderClassName;
    protected IImplementationUIProvider provider;
    private Expression expression;

    public SCAImplementationUIExtensibilityElementDescriptor(String namespace, String elementName, Bundle bundle, String uiProviderClassName, Expression expression) {
        this.namespace = namespace;
        this.elementName = elementName;
        this.bundle = bundle;
        this.uiProviderClassName = uiProviderClassName;
        this.expression = expression;
    }

    public boolean isEnabled(Component component) {
        SCAPreferences preferences = SCAToolsCorePlugin.getInstance().getPreferences();
        IProject project = ScaUtil.getIFile().getProject();
        List implEntries = preferences.getEnabledImplTypes(project);
        boolean foundEnabled = false;
        for (ImplTypeEntry entry : implEntries) {
            if (!entry.getID().equals(this.elementName)) continue;
            foundEnabled = entry.isEnabled(project);
            break;
        }
        if (!foundEnabled) {
            return false;
        }
        if (this.expression == null) {
            return true;
        }
        boolean result = false;
        EvaluationContext context = new EvaluationContext(null, (Object)new ComponentImplementationResource(component));
        context.addVariable("component", (Object)component);
        context.setAllowPluginActivation(true);
        try {
            EvaluationResult expResult = this.expression.evaluate((IEvaluationContext)context);
            if (expResult != EvaluationResult.FALSE) {
                result = true;
            }
        }
        catch (CoreException exc) {
            ScaDiagramEditorPlugin.traceError((Exception)((Object)exc));
        }
        return result;
    }

    public IImplementationUIProvider getUIProvider() {
        if (this.provider == null) {
            try {
                Class theClass = this.bundle.loadClass(this.uiProviderClassName);
                this.provider = (IImplementationUIProvider)theClass.newInstance();
            }
            catch (Exception e) {
                ScaDiagramEditorPlugin.traceError(e);
            }
        }
        return this.provider;
    }
}

