/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.sca;

import com.ibm.ccl.sca.composite.emf.sca.Binding;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.attributes.IAnyAttributeUIProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.attributes.SCAAnyAttributeUIExtensibilityElementFactoryRegistry;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.actions.AddPolicySetAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.actions.EditBindingNameAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.actions.EditBindingUriAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.actions.RemovePolicySetAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.AddRemoveTableControls;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.DelayedTextModifyListener;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.PolicySetContentProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.QNameLabelProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.base.controls.IPropertiesSectionAreaExtender;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.base.controls.IPropertiesTitledSectionAreaExtender;
import com.ibm.ccl.sca.composite.ui.custom.intents.AddRequiresAction;
import com.ibm.ccl.sca.composite.ui.custom.intents.RemoveRequiresAction;
import com.ibm.ccl.sca.composite.ui.custom.intents.RequiresContentProvider;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import com.ibm.ccl.sca.composite.ui.sheet.SCABaseDetailsPropertiesPage;
import com.ibm.ccl.sca.internal.ui.common.controls.intents.IntentQNameLabelProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class SCABindingDetailsPropertiesPage
extends SCABaseDetailsPropertiesPage {
    protected Binding binding;
    private Text nameText;
    private Text uriText;
    private AddRemoveTableControls psAddRemoveControls;
    private AddRemoveTableControls reqAddRemoveControls;
    private DetailsCustomListener customListener = new DetailsCustomListener();
    List<IPropertiesSectionAreaExtender> extenders = new ArrayList<IPropertiesSectionAreaExtender>();
    private List<String> parentBindingsList;

    @Override
    protected void doCreateContents(Composite parent) {
        this.createNameAndIdentitySection(parent);
        this.createVerticalWhitespace(parent);
        this.createPolicySetsAndIntentsSection(parent);
    }

    protected Composite createNameAndIdentitySection(Composite parent, String sectionTitle) {
        Composite client = this.createNewSection(parent, sectionTitle, SECTION_STYLE, 2);
        this.toolkit.createLabel(client, Messages.SCABindingDetailsPropertiesPage_1);
        this.nameText = this.toolkit.createText(client, "", 4);
        GridData gd = new GridData(770);
        gd.widthHint = 10;
        this.nameText.setLayoutData((Object)gd);
        this.createURIControls(client);
        this.applyListeners((Control)this.nameText);
        this.applyListeners((Control)this.uriText);
        return client;
    }

    protected Composite createNameAndIdentitySection(Composite parent) {
        return this.createNameAndIdentitySection(parent, Messages.SCABindingDetailsPropertiesPage_0);
    }

    protected void createURIControls(Composite parent) {
        this.toolkit.createLabel(parent, Messages.SCABindingDetailsPropertiesPage_3);
        this.uriText = this.toolkit.createText(parent, "", 4);
        GridData gd = new GridData(770);
        gd.widthHint = 10;
        this.uriText.setLayoutData((Object)gd);
    }

    protected Composite createPolicySetsAndIntentsSection(Composite parent) {
        Composite psRequiresComp = this.createNewSection(parent, Messages.SCABindingDetailsPropertiesPage_5, SECTION_STYLE, 2);
        this.reqAddRemoveControls = new AddRemoveTableControls(this.toolkit, psRequiresComp, Messages.SCABaseImplementationPropertySection_13);
        this.reqAddRemoveControls.setContentProvider((IContentProvider)new RequiresContentProvider());
        this.reqAddRemoveControls.setLabelProvider((ILabelProvider)new IntentQNameLabelProvider());
        this.psAddRemoveControls = new AddRemoveTableControls(this.toolkit, psRequiresComp, Messages.SCABindingDetailsPropertiesPage_7);
        this.psAddRemoveControls.setContentProvider((IContentProvider)new PolicySetContentProvider());
        this.psAddRemoveControls.setLabelProvider(new QNameLabelProvider());
        return psRequiresComp;
    }

    protected void createExtendedAreaControls(Composite parent, EObject theObject) {
        int style = 322;
        ArrayList<String> projectFacets = new ArrayList<String>();
        try {
            IProject iProject = ScaUtil.getCurrentResource().getProject();
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)iProject, (boolean)true, null);
            for (IProjectFacetVersion facetVersion : facetedProject.getProjectFacets()) {
                projectFacets.add(facetVersion.getProjectFacet().getId());
            }
        }
        catch (Exception e) {
            ScaDiagramEditorPlugin.traceError(e);
        }
        SCAAnyAttributeUIExtensibilityElementFactoryRegistry registry = ScaDiagramEditorPlugin.getInstance().getSCAAnyAttributeUIExtensibilityElementProviderRegistry();
        for (IAnyAttributeUIProvider provider : registry.getExtensibilityElementUIProviders()) {
            List<String> facets = registry.getApplicableProjectFacets(provider);
            if (!ScaUtil.collectionContainsItem(facets, projectFacets) || !provider.appliesTo(theObject)) continue;
            this.createVerticalWhitespace(parent);
            IPropertiesTitledSectionAreaExtender extender = provider.getContributedControls();
            Section section = this.toolkit.createSection(parent, style);
            section.setText(extender.getControlTitle());
            GridData gd = new GridData(1808);
            section.setLayoutData((Object)gd);
            Composite client = this.toolkit.createComposite((Composite)section);
            GridLayout glayout = new GridLayout();
            client.setLayout((Layout)glayout);
            extender.createExtendedControls(this.toolkit, client);
            this.extenders.add(extender);
            section.setClient((Control)client);
            this.toolkit.paintBordersFor(client);
        }
    }

    public void dispose() {
        if (this.psAddRemoveControls != null) {
            this.psAddRemoveControls.dispose();
        }
        if (this.reqAddRemoveControls != null) {
            this.reqAddRemoveControls.dispose();
        }
        Iterator<IPropertiesSectionAreaExtender> it = this.extenders.iterator();
        while (it.hasNext()) {
            it.next().dispose();
        }
        this.parentBindingsList = null;
    }

    public void refresh() {
        this.removeListeners((Control)this.nameText);
        this.removeListeners((Control)this.uriText);
        if (this.nameText != null) {
            String name;
            this.nameText.setText("");
            if (this.binding.getName() != null && (name = this.binding.getName().getLocalPart()) != null) {
                this.nameText.setText(name);
            }
        }
        if (this.uriText != null) {
            this.uriText.setText("");
            if (this.binding.getUri() != null) {
                this.uriText.setText(this.binding.getUri());
            }
        }
        this.refreshTableControls();
        this.fullStatusLineUpdate();
        Iterator<IPropertiesSectionAreaExtender> it = this.extenders.iterator();
        while (it.hasNext()) {
            it.next().refresh();
        }
        this.applyListeners((Control)this.nameText);
        this.applyListeners((Control)this.uriText);
    }

    protected void refreshTableControls() {
        this.psAddRemoveControls.setTarget((Notifier)this.binding);
        this.reqAddRemoveControls.setTarget((Notifier)this.binding);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() > 0) {
            this.binding = (Binding)sel.getFirstElement();
            this.setTableControlsActions();
        } else {
            this.binding = null;
        }
        Iterator<IPropertiesSectionAreaExtender> it = this.extenders.iterator();
        while (it.hasNext()) {
            it.next().setInput(this.binding);
        }
        this.refresh();
    }

    protected void setTableControlsActions() {
        this.psAddRemoveControls.setAddButtonAction(new AddPolicySetAction(this.getWorkbenchPart(), (EObject)this.binding));
        this.psAddRemoveControls.setRemoveButtonAction(new RemovePolicySetAction(this.getWorkbenchPart(), (EObject)this.binding));
        this.reqAddRemoveControls.setAddButtonAction(new AddRequiresAction(this.getWorkbenchPart(), (EObject)this.binding));
        this.reqAddRemoveControls.setRemoveButtonAction(new RemoveRequiresAction(this.getWorkbenchPart(), (EObject)this.binding));
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    private void applyListeners(Control control) {
        if (control != null) {
            control.addListener(16, (Listener)this.customListener);
            control.addListener(2, (Listener)this.customListener);
        }
    }

    private void removeListeners(Control control) {
        if (control != null) {
            control.removeListener(16, (Listener)this.customListener);
            control.removeListener(2, (Listener)this.customListener);
        }
    }

    protected void quickStatusLineUpdate() {
        String name = this.nameText.getText();
        if (this.parentBindingsList == null) {
            this.fullStatusLineUpdate();
        } else {
            this.updateStatusLineForName(this.parentBindingsList, name);
        }
    }

    protected void fullStatusLineUpdate() {
        String name = this.nameText.getText();
        this.parentBindingsList = new ArrayList<String>();
        EList bindings = new ArrayList();
        if (this.parentObject instanceof Service) {
            bindings = ((Service)this.parentObject).getBinding();
        } else if (this.parentObject instanceof Reference) {
            bindings = ((Reference)this.parentObject).getBinding();
        }
        for (Binding b : bindings) {
            if (b.equals(this.binding) || b.getName() == null) continue;
            this.parentBindingsList.add(b.getName().getLocalPart());
        }
        this.updateStatusLineForName(this.parentBindingsList, name);
    }

    private void updateStatusLineForName(List<String> existingList, String name) {
        if (existingList.contains(name)) {
            this.setStatusLineMessasge(Messages.bind((String)Messages.SCABindingDetailsPropertiesPage_11, (Object)name));
        } else {
            this.setStatusLineMessasge(null);
        }
    }

    private class DetailsCustomListener
    extends DelayedTextModifyListener {
        private DetailsCustomListener() {
        }

        @Override
        protected void executeHandleEvent(Event event) {
            String newValue;
            if (event.widget == SCABindingDetailsPropertiesPage.this.nameText && !SCABindingDetailsPropertiesPage.this.nameText.isDisposed()) {
                newValue = SCABindingDetailsPropertiesPage.this.nameText.getText();
                String originalValue = "";
                if (SCABindingDetailsPropertiesPage.this.binding.getName() != null) {
                    originalValue = SCABindingDetailsPropertiesPage.this.binding.getName().getLocalPart();
                }
                if (!newValue.equals(originalValue)) {
                    EditBindingNameAction action = new EditBindingNameAction(SCABindingDetailsPropertiesPage.this.getWorkbenchPart(), SCABindingDetailsPropertiesPage.this.binding, newValue);
                    action.run();
                }
            }
            if (SCABindingDetailsPropertiesPage.this.uriText != null && event.widget == SCABindingDetailsPropertiesPage.this.uriText && !SCABindingDetailsPropertiesPage.this.uriText.isDisposed() && !(newValue = SCABindingDetailsPropertiesPage.this.uriText.getText()).equals(SCABindingDetailsPropertiesPage.this.binding.getUri())) {
                EditBindingUriAction action = new EditBindingUriAction(SCABindingDetailsPropertiesPage.this.getWorkbenchPart(), SCABindingDetailsPropertiesPage.this.binding, newValue);
                action.run();
            }
        }

        @Override
        protected void executeHandleKeyUpEvent(Event event) {
            if (event.widget == SCABindingDetailsPropertiesPage.this.nameText && !SCABindingDetailsPropertiesPage.this.nameText.isDisposed()) {
                SCABindingDetailsPropertiesPage.this.quickStatusLineUpdate();
            }
        }
    }
}

