/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls;

import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.ButtonPopupDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ButtonPopup {
    private Map<String, ButtonPopupDescriptor> popupDescriptorMap = new HashMap<String, ButtonPopupDescriptor>();
    private Shell shell;
    private String selectedText;

    public ButtonPopup(Shell parent) {
        this.shell = new Shell(parent, ButtonPopup.checkStyle(0));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.shell.setLayout((Layout)layout);
        this.shell.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                ButtonPopup.this.shell.dispose();
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 0x6000000;
        return style & mask;
    }

    public void open(Point location, List<ButtonPopupDescriptor> descriptors) {
        Iterator<ButtonPopupDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            Button button = new Button((Composite)this.shell, 8);
            GridData data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            ButtonPopupDescriptor buttonDescriptor = it.next();
            Image image = buttonDescriptor.getImage();
            if (image != null) {
                button.setImage(image);
            }
            String text = buttonDescriptor.getText();
            button.setText(text);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e1) {
                    ButtonPopup.this.selectedText = ((Button)e1.widget).getText();
                    ButtonPopup.this.shell.dispose();
                }
            });
            button.setLayoutData((Object)data);
            this.popupDescriptorMap.put(text, buttonDescriptor);
        }
        Point listSize = this.shell.computeSize(-1, -1, false);
        this.shell.setBounds(location.x, location.y, listSize.x, listSize.y);
        this.shell.open();
        this.shell.setFocus();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() && this.shell.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public ButtonPopupDescriptor getSelectedPopupDescriptor() {
        return this.popupDescriptorMap.get(this.selectedText);
    }
}

