/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class AddDialog
extends Dialog {
    private String dialogTitle;
    private Object inputObject;
    private ISelection selection;
    private TreeViewer treeViewer;
    private IBaseLabelProvider labelProvider;
    private ITreeContentProvider contentProvider;
    private Map<Integer, Listener> treeListenerMap = new HashMap<Integer, Listener>();
    private List<?> greyOutObjectList = new ArrayList();
    private ISelectionChangedListener selectionChangedListener;

    public AddDialog(Shell parentShell, String dialogTitle, Object inputObject) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
        this.inputObject = inputObject;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.selection = this.treeViewer.getSelection();
        super.okPressed();
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.dialogTitle);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 250;
        composite.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer(composite, 2048);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setInput(this.inputObject);
        this.treeViewer.setLabelProvider(this.labelProvider);
        for (Integer eventType : this.treeListenerMap.keySet()) {
            Listener listener = this.treeListenerMap.get(eventType);
            this.treeViewer.getTree().addListener(eventType.intValue(), listener);
        }
        if (this.selectionChangedListener != null) {
            this.treeViewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        data = new GridData(1808);
        data.widthHint = 250;
        data.heightHint = 200;
        this.treeViewer.getControl().setLayoutData((Object)data);
        TreeItem[] treeItems = this.treeViewer.getTree().getItems();
        int i = 0;
        while (i < treeItems.length) {
            TreeItem treeItem = treeItems[i];
            if (this.greyOutObjectList.contains(treeItem.getData())) {
                treeItem.setForeground(ColorConstants.gray);
            }
            ++i;
        }
        data = new GridData(1808);
        data.widthHint = 250;
        data.heightHint = 200;
        this.treeViewer.getTree().setLayoutData((Object)data);
        return composite;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void addTreeListener(int eventType, Listener listener) {
        this.treeListenerMap.put(eventType, listener);
    }

    public void setSelectionTreeListener(ISelectionChangedListener selectionChangedListener) {
        this.selectionChangedListener = selectionChangedListener;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setGrayOutTreeItemList(List<?> dataObjects) {
        this.greyOutObjectList = dataObjects;
    }

    public Button getOKButton() {
        return this.getButton(0);
    }
}

