/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.binding;

import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.BindingResource;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.IBindingUIProvider;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.osgi.framework.Bundle;

public class SCABindingUIExtensibilityElementDescriptor {
    public static String NAMESPACE_AND_NAME_SEPARATOR = "#";
    protected Bundle bundle;
    protected String namespace;
    protected String elementName;
    protected String uiProviderClassName;
    protected IBindingUIProvider provider;
    private Expression expression;

    public SCABindingUIExtensibilityElementDescriptor(String namespace, String elementName, Bundle bundle, String uiProviderClassName, Expression expression) {
        this.namespace = namespace;
        this.elementName = elementName;
        this.bundle = bundle;
        this.uiProviderClassName = uiProviderClassName;
        this.expression = expression;
    }

    public IBindingUIProvider getUIProvider() {
        if (this.provider == null) {
            try {
                Class theClass = this.bundle.loadClass(this.uiProviderClassName);
                this.provider = (IBindingUIProvider)theClass.newInstance();
            }
            catch (Exception e) {
                ScaDiagramEditorPlugin.traceError(e);
            }
        }
        return this.provider;
    }

    public boolean isEnabled(EObject eObject) {
        if (this.expression == null) {
            return true;
        }
        boolean result = false;
        EvaluationContext context = new EvaluationContext(null, (Object)new BindingResource(eObject));
        context.addVariable("eobject", (Object)eObject);
        context.setAllowPluginActivation(true);
        try {
            EvaluationResult expResult = this.expression.evaluate((IEvaluationContext)context);
            if (expResult != EvaluationResult.FALSE) {
                result = true;
            }
        }
        catch (CoreException exc) {
            ScaDiagramEditorPlugin.traceError((Exception)((Object)exc));
        }
        return result;
    }
}

