/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.emf.commands;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.ComponentReference;
import com.ibm.ccl.sca.composite.emf.sca.ComponentService;
import com.ibm.ccl.sca.composite.emf.sca.Reference;
import com.ibm.ccl.sca.composite.emf.sca.Service;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;

public class DeleteReferenceToServiceCommand
extends EditElementCommand {
    private DestroyReferenceRequest request;

    public DeleteReferenceToServiceCommand(DestroyReferenceRequest request) {
        super(request.getLabel(), request.getContainer(), (IEditCommandRequest)request);
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.request.getContainer() instanceof ComponentReference && this.request.getReferencedObject() instanceof ComponentService) {
            Component serviceComp;
            ComponentReference ref = (ComponentReference)this.request.getContainer();
            ComponentService service = (ComponentService)this.request.getReferencedObject();
            String serviceString = ScaUtil.getComponentServiceString(service);
            List targets = ref.getTarget();
            if (targets == null) {
                return CommandResult.newOKCommandResult();
            }
            boolean removed = targets.remove(serviceString);
            if (!removed && (serviceComp = (Component)service.eContainer()).getService().size() == 1) {
                targets.remove(serviceComp.getName());
            }
            if (targets.size() == 0) {
                ref.setTarget(null);
            }
        } else if (this.request.getContainer() instanceof Service && this.request.getReferencedObject() instanceof ComponentService) {
            Service service = (Service)this.request.getContainer();
            ComponentService compServ = (ComponentService)this.request.getReferencedObject();
            String promoteString = ScaUtil.getComponentServiceString(compServ);
            if (promoteString.equals(service.getPromote())) {
                service.setPromote(null);
            }
        } else if (this.request.getContainer() instanceof ComponentReference && this.request.getReferencedObject() instanceof Reference) {
            ComponentReference compRef = (ComponentReference)this.request.getContainer();
            Reference ref = (Reference)this.request.getReferencedObject();
            String promoteString = ScaUtil.getComponentReferenceString(compRef);
            List promoteList = ref.getPromote();
            promoteList.remove(promoteString);
            if (promoteList.size() == 0) {
                ref.setPromote(null);
            }
        }
        return CommandResult.newOKCommandResult();
    }
}

