/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.edit.parts;

import com.ibm.ccl.sca.composite.emf.sca.Binding;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.IBindingUIProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.SCABindingUIExtensibilityElementDescriptor;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.SCABindingUIExtensibilityElementFactoryRegistry;
import com.ibm.ccl.sca.composite.ui.custom.figures.OverlayIndicatorFigureSupport;
import com.ibm.ccl.sca.composite.ui.custom.util.SCALayerManager;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorPart;

public abstract class OverlayIndicatorEditPartSupport
extends ShapeNodeEditPart {
    public ScalableImageFigure imageFigure;

    public abstract void createOverlayIndicators();

    public OverlayIndicatorEditPartSupport(View view) {
        super(view);
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTrackerEx((EditPart)this);
    }

    public void refresh() {
        super.refresh();
        this.createOverlayIndicators();
    }

    public void deactivate() {
        if (this.getFigure() instanceof OverlayIndicatorFigureSupport) {
            ((OverlayIndicatorFigureSupport)this.getFigure()).removeIndicators();
        }
        super.deactivate();
    }

    public void updateOverlayIndicators() {
        if (this.imageFigure != null) {
            this.getFigure().getLayoutManager().layout(this.getFigure());
        }
    }

    protected void createBindingOverlayIndicators(List<Binding> bindings) {
        if (this.getFigure() instanceof OverlayIndicatorFigureSupport) {
            RenderedImage image = null;
            IEditorPart editorPart = ((DiagramEditDomain)this.getEditDomain()).getEditorPart();
            SCALayerManager layerManager = (SCALayerManager)editorPart.getAdapter(SCALayerManager.class);
            SCABindingUIExtensibilityElementFactoryRegistry registry = ScaDiagramEditorPlugin.getInstance().getSCABindingUIExtensibilityElementProviderRegistry();
            List<SCABindingUIExtensibilityElementDescriptor> providers = registry.getExtensibilityElementUIProviders();
            if (bindings.size() == 1) {
                Binding binding = bindings.get(0);
                for (SCABindingUIExtensibilityElementDescriptor extProvider : providers) {
                    IBindingUIProvider provider = extProvider.getUIProvider();
                    if (!provider.appliesTo(binding)) continue;
                    image = provider.getSVGImageBindingIndicator();
                    break;
                }
            } else {
                image = bindings.size() > 1 ? ScaDiagramEditorPlugin.getScalableImage("icons/svg/multiple_binding_indicator.svg") : ScaDiagramEditorPlugin.getScalableImage("icons/svg/implicit_binding_indicator.svg");
            }
            if (image != null) {
                if (this.imageFigure == null) {
                    this.imageFigure = new ScalableImageFigure(image, true, true, true);
                    layerManager.getLayer(SCALayerManager.BINDING_INDICATOR_LAYER).add((IFigure)this.imageFigure);
                    ((OverlayIndicatorFigureSupport)this.getFigure()).getIndicators().add((IFigure)this.imageFigure);
                    this.imageFigure.setSize(8, 8);
                }
                this.imageFigure.setRenderedImage(image);
            }
        }
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (feature instanceof EReference) {
            EReference ref = (EReference)feature;
            Class refClass = ref.getEType().getInstanceClass();
            if (Binding.class.isAssignableFrom(refClass)) {
                this.refresh();
            } else {
                super.handleNotificationEvent(notification);
            }
        } else {
            super.handleNotificationEvent(notification);
        }
    }
}

