/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.dialogs.providers;

import com.ibm.ccl.sca.composite.emf.sca.JavaImplementation;
import com.ibm.ccl.sca.composite.emf.sca.SCAFactory;
import com.ibm.ccl.sca.composite.ui.custom.dialogs.ComponentDescription;
import com.ibm.ccl.sca.composite.ui.custom.dialogs.providers.ISCADialogProvider;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class SCAJavaImplementationDialogProvider
implements ISCADialogProvider {
    protected IProject project;

    public SCAJavaImplementationDialogProvider(IProject project) {
        this.project = project;
    }

    @Override
    public Object getValueObject(Object value) {
        if (value instanceof ComponentDescription) {
            ComponentDescription desc = (ComponentDescription)value;
            JavaImplementation impl = SCAFactory.eINSTANCE.createJavaImplementation();
            impl.setClass((String)desc.getProperty("STRING_VALUE"));
            return impl;
        }
        return null;
    }

    @Override
    public List getSelectionValues() {
        ArrayList<ComponentDescription> list = new ArrayList<ComponentDescription>();
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        JavaResourceHelper helper = new JavaResourceHelper();
        block2: for (Object item : helper.getJavaFiles(javaProject)) {
            if (!(item instanceof ICompilationUnit)) continue;
            ICompilationUnit unit = (ICompilationUnit)item;
            try {
                IType[] types = unit.getTypes();
                int index = 0;
                while (index < types.length) {
                    IType type = types[index];
                    if (type.isClass()) {
                        String name = type.getElementName();
                        String qualifier = type.getFullyQualifiedName();
                        qualifier = qualifier.substring(0, qualifier.length() - name.length() - 1);
                        ComponentDescription desc = new ComponentDescription(name, qualifier, null);
                        desc.addProperty("STRING_VALUE", type.getFullyQualifiedName());
                        list.add(desc);
                        continue block2;
                    }
                    ++index;
                }
            }
            catch (Exception e) {
                ScaDiagramEditorPlugin.traceError(e);
            }
        }
        return list;
    }

    private class JavaResourceHelper {
        private JavaResourceHelper() {
        }

        public List getJavaFiles(IJavaProject project) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (project != null && project.exists()) {
                try {
                    IJavaElement[] elements = project.getChildren();
                    int index = 0;
                    while (index < elements.length) {
                        if (elements[index] instanceof IPackageFragmentRoot) {
                            IPackageFragmentRoot fragment = (IPackageFragmentRoot)elements[index];
                            this.getJavaFiles(fragment, list);
                        }
                        ++index;
                    }
                }
                catch (Exception e) {
                    ScaDiagramEditorPlugin.traceError(e);
                }
            }
            return list;
        }

        public void getJavaFiles(IPackageFragmentRoot root, List<Object> list) throws Exception {
            IJavaElement[] kids = root.getChildren();
            int index = 0;
            while (index < kids.length) {
                if (kids[index] instanceof IPackageFragment) {
                    IPackageFragment pkgFragment = (IPackageFragment)kids[index];
                    this.getJavaFiles(pkgFragment, list);
                }
                ++index;
            }
        }

        public void getJavaFiles(IPackageFragment pkgFragment, List<Object> list) throws Exception {
            ICompilationUnit[] compUnits = pkgFragment.getCompilationUnits();
            int index = 0;
            while (index < compUnits.length) {
                ICompilationUnit unit = compUnits[index];
                if (unit.getTypes().length > 0) {
                    list.add(unit);
                }
                ++index;
            }
        }
    }
}

