/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.dialogs.providers;

import com.ibm.ccl.sca.composite.emf.sca.SCAFactory;
import com.ibm.ccl.sca.composite.emf.sca.SCAImplementation;
import com.ibm.ccl.sca.composite.ui.custom.dialogs.ComponentDescription;
import com.ibm.ccl.sca.composite.ui.custom.dialogs.providers.ISCADialogProvider;
import com.ibm.ccl.sca.composite.ui.part.ScaDiagramEditorPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SCACompositeImplementationDialogProvider
implements ISCADialogProvider {
    protected IProject project;

    public SCACompositeImplementationDialogProvider(IProject project) {
        this.project = project;
    }

    @Override
    public Object getValueObject(Object value) {
        if (value instanceof ComponentDescription) {
            ComponentDescription newValue = (ComponentDescription)value;
            String compositeName = (String)newValue.getProperty("STRING_VALUE");
            FileInputStream inputStream = null;
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                XMLReader reader = parser.getXMLReader();
                reader.setFeature("http://xml.org/sax/features/namespaces", true);
                CompositeQuickScanContentHandler handler = new CompositeQuickScanContentHandler();
                String fullFilePath = ((IPath)newValue.getProperty("FULL_FILEPATH")).toOSString();
                inputStream = new FileInputStream(new File(fullFilePath));
                reader.setContentHandler(handler);
                reader.parse(new InputSource(inputStream));
                String tns = handler.getTargetNamespace();
                if (tns == null) {
                    tns = "";
                }
                SCAImplementation impl = SCAFactory.eINSTANCE.createSCAImplementation();
                impl.setName(new QName(tns, compositeName));
                SCAImplementation sCAImplementation = impl;
                return sCAImplementation;
            }
            catch (Exception e) {
                ScaDiagramEditorPlugin.traceError(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        ScaDiagramEditorPlugin.traceError(e);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public List getSelectionValues() {
        ArrayList<ComponentDescription> list = new ArrayList<ComponentDescription>();
        for (IFile file : this.getProjectFiles("composite", (IContainer)this.project)) {
            String filePath = file.getFullPath().removeLastSegments(1).toString();
            String fileName = file.getName();
            ComponentDescription desc = new ComponentDescription(fileName, filePath, null);
            desc.addProperty("STRING_VALUE", file.getFullPath().removeFileExtension().lastSegment());
            desc.addProperty("FULL_FILEPATH", file.getLocation());
            list.add(desc);
        }
        return list;
    }

    private List getProjectFiles(String ext, IContainer container) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        try {
            IResource[] members = container.members();
            int index = 0;
            while (index < members.length) {
                if (members[index] instanceof IFile) {
                    IFile file = (IFile)members[index];
                    if (file.getFileExtension().equals(ext)) {
                        files.add(file);
                    }
                } else if (members[index] instanceof IFolder) {
                    files.addAll(this.getProjectFiles(ext, (IContainer)((IFolder)members[index])));
                }
                ++index;
            }
        }
        catch (Exception e) {
            ScaDiagramEditorPlugin.traceError(e);
        }
        return files;
    }

    private class CompositeQuickScanContentHandler
    extends DefaultHandler {
        private String targetnamespace;

        private CompositeQuickScanContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("composite")) {
                this.targetnamespace = attributes.getValue("targetNamespace");
            }
        }

        public String getTargetNamespace() {
            return this.targetnamespace;
        }
    }
}

