/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.actions;

import com.ibm.ccl.sca.composite.emf.sca.Component;
import com.ibm.ccl.sca.composite.emf.sca.Composite;
import com.ibm.ccl.sca.composite.emf.sca.Implementation;
import com.ibm.ccl.sca.composite.emf.sca.Include;
import com.ibm.ccl.sca.composite.emf.sca.SCAFactory;
import com.ibm.ccl.sca.composite.emf.sca.SCAImplementation;
import com.ibm.ccl.sca.composite.ui.custom.actions.SCABaseAction;
import com.ibm.ccl.sca.composite.ui.custom.emf.commands.SCAAddAndSetCompositeImplementationCommand;
import com.ibm.ccl.sca.core.model.ISCAComposite;
import com.ibm.ccl.sca.internal.ui.common.controls.ICompositeSelectionDialog;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class SCAAddAndSetCompositeImplementationAction
extends SCABaseAction {
    protected ICompositeSelectionDialog dialog;
    protected Component component;
    protected IWorkbenchPart part;

    public SCAAddAndSetCompositeImplementationAction(IWorkbenchPart part, String title, Component component) {
        super(part);
        this.setText(title);
        this.component = component;
        this.part = part;
    }

    public void setDialog(ICompositeSelectionDialog dialog) {
        this.dialog = dialog;
    }

    private List<QName> getIncludedQNames(Composite composite) {
        ArrayList<QName> names = new ArrayList<QName>();
        for (Include include : composite.getInclude()) {
            QName name = include.getName();
            if (name == null || names.contains(name)) continue;
            names.add(include.getName());
        }
        return names;
    }

    public void run() {
        Composite composite = (Composite)this.component.eContainer();
        ArrayList<QName> ignoreList = new ArrayList<QName>();
        ignoreList.add(new QName(composite.getTargetNamespace(), composite.getName()));
        ignoreList.addAll(this.getIncludedQNames(composite));
        this.dialog.setCurrentResource((IResource)this.getCompositeFile(this.part));
        this.dialog.initialize();
        this.dialog.setIgnoredQNames(ignoreList);
        int rValue = this.dialog.open();
        if (rValue == 0 && this.dialog.getSelectedComposites().size() > 0) {
            List list = this.dialog.getSelectedComposites();
            QName name = ((ISCAComposite)list.get(0)).getName();
            SCAImplementation impl = SCAFactory.eINSTANCE.createSCAImplementation();
            impl.setName(name);
            if (impl instanceof Implementation) {
                EReference eReference = this.getEReference((EObject)this.component, "implementation");
                SetRequest request = new SetRequest((EObject)this.component, (EStructuralFeature)eReference, (Object)impl);
                SCAAddAndSetCompositeImplementationCommand command = new SCAAddAndSetCompositeImplementationCommand(request, this.component, (Implementation)impl);
                ICommandProxy commandProxy = new ICommandProxy((ICommand)command);
                this.getCommandStack().execute((Command)commandProxy);
            }
        }
    }

    private IFile getCompositeFile(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            IEditorInput input = ((IEditorPart)part).getEditorInput();
            IFile diagramFile = (IFile)input.getAdapter(IFile.class);
            String filename = diagramFile.getName();
            filename = filename.substring(0, filename.length() - 8);
            return diagramFile.getParent().getFile((IPath)new Path(filename));
        }
        return null;
    }
}

