/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.ws.extensibility.attributes.ui;

import com.ibm.ccl.sca.composite.emf.ws.Messages;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.attributes.ui.WASAnyAttributeContentProvider;
import com.ibm.ccl.sca.composite.emf.ws.extensibility.attributes.ui.actions.WASModifyEMFAttributeAction;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.binding.base.controls.DelayedTextModifyListener;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.base.controls.IPropertiesTitledSectionAreaExtender;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WASAnyAttributeServiceExtender
implements IPropertiesTitledSectionAreaExtender {
    private Object inputObject;
    private Text wsPolicySet;
    private Text wsServicePolicySetBinding;
    private TextListener textListener = new TextListener();

    public String getControlTitle() {
        return Messages.LABEL_WEB_SERVICE_POLICY_SET_ATTRIBUTES;
    }

    public void createExtendedControls(FormToolkit toolkit, Composite parent) {
        Composite comp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        toolkit.createLabel(comp, Messages.LABEL_WEB_SERVICE_POLICY_SET);
        this.wsPolicySet = toolkit.createText(comp, "");
        gd = new GridData(770);
        this.wsPolicySet.setLayoutData((Object)gd);
        toolkit.createLabel(comp, Messages.LABEL_WEB_SERVICE_REFERENCE_POLICY_SET);
        this.wsServicePolicySetBinding = toolkit.createText(comp, "");
        gd = new GridData(770);
        this.wsServicePolicySetBinding.setLayoutData((Object)gd);
        toolkit.paintBordersFor(comp);
    }

    public void dispose() {
    }

    public void setInput(Object input) {
        this.inputObject = input;
        this.refresh();
    }

    protected void removeListeners(Control control) {
        if (control != null && !control.isDisposed()) {
            control.removeListener(16, (Listener)this.textListener);
            control.removeListener(2, (Listener)this.textListener);
        }
    }

    protected void addListeners(Control control) {
        if (control != null && !control.isDisposed()) {
            control.addListener(16, (Listener)this.textListener);
            control.addListener(2, (Listener)this.textListener);
        }
    }

    public void refresh() {
        if (this.wsPolicySet == null || this.wsPolicySet.isDisposed()) {
            return;
        }
        this.removeListeners((Control)this.wsPolicySet);
        this.removeListeners((Control)this.wsServicePolicySetBinding);
        this.wsPolicySet.setText("");
        this.wsServicePolicySetBinding.setText("");
        if (this.inputObject != null) {
            String v1 = this.getAttributeValue(WASAnyAttributeContentProvider.WS_POLICY_SET_ATTRIBUTE_NAME);
            String v2 = this.getAttributeValue(WASAnyAttributeContentProvider.WS_SERVICE_POLICY_SET_ATTRIBUTE_NAME);
            if (v1 != null && v1.length() > 0) {
                this.wsPolicySet.setText(v1);
            }
            if (v2 != null && v2.length() > 0) {
                this.wsServicePolicySetBinding.setText(v2);
            }
        }
        this.addListeners((Control)this.wsPolicySet);
        this.addListeners((Control)this.wsServicePolicySetBinding);
    }

    private String getAttributeValue(String attribute) {
        return WASAnyAttributeContentProvider.getRawAttributeValues(this.inputObject, attribute);
    }

    private class TextListener
    extends DelayedTextModifyListener {
        private TextListener() {
        }

        protected void executeHandleEvent(Event event) {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            String ns = WASAnyAttributeContentProvider.WS_POLICY_SET_NAMESPACE;
            if (event.widget == WASAnyAttributeServiceExtender.this.wsPolicySet && !WASAnyAttributeServiceExtender.this.wsPolicySet.isDisposed()) {
                String existingValue;
                String text = WASAnyAttributeServiceExtender.this.wsPolicySet.getText();
                if (text.trim().equals("")) {
                    text = null;
                }
                if ((existingValue = WASAnyAttributeServiceExtender.this.getAttributeValue(WASAnyAttributeContentProvider.WS_POLICY_SET_ATTRIBUTE_NAME)) == null || !existingValue.equals(text)) {
                    WASModifyEMFAttributeAction action = new WASModifyEMFAttributeAction(part, (EObject)WASAnyAttributeServiceExtender.this.inputObject, WASAnyAttributeContentProvider.WS_POLICY_SET_ATTRIBUTE_NAME, ns, text);
                    action.run();
                }
            } else if (event.widget == WASAnyAttributeServiceExtender.this.wsServicePolicySetBinding && !WASAnyAttributeServiceExtender.this.wsServicePolicySetBinding.isDisposed()) {
                String existingValue;
                String text = WASAnyAttributeServiceExtender.this.wsServicePolicySetBinding.getText();
                if (text.trim().equals("")) {
                    text = null;
                }
                if ((existingValue = WASAnyAttributeServiceExtender.this.getAttributeValue(WASAnyAttributeContentProvider.WS_SERVICE_POLICY_SET_ATTRIBUTE_NAME)) == null || !existingValue.equals(text)) {
                    WASModifyEMFAttributeAction action = new WASModifyEMFAttributeAction(part, (EObject)WASAnyAttributeServiceExtender.this.inputObject, WASAnyAttributeContentProvider.WS_SERVICE_POLICY_SET_ATTRIBUTE_NAME, ns, text);
                    action.run();
                }
            }
        }
    }
}

