/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.widget;

import com.ibm.ccl.sca.composite.emf.sca.Implementation;
import com.ibm.ccl.sca.composite.emf.tuscany.TUSCANYPackage;
import com.ibm.ccl.sca.composite.emf.widget.impl.Messages;
import com.ibm.ccl.sca.composite.emf.widget.impl.ui.WidgetSelectionDialogFactory;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.base.controls.IPropertiesSectionAreaExtender;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.TextFieldsWithBrowseControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.DataObject;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFAttributeDataObject;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFReferenceContainer;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.ui.util.EventTimer;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class WidgetImplPropertiesSectionAreaExtender
implements IPropertiesSectionAreaExtender {
    private EMFSection mainSection;
    private Implementation impl;
    private EventTimer timer = EventTimer.acquireTimer();
    private EMFReferenceContainer container;
    private EMFAttributeDataObject data;

    public void createExtendedControls(FormToolkit toolkit, Composite implComp) {
        this.container = new EMFReferenceContainer(null, null, ScaUtil.getResourceEditDomain());
        this.data = new EMFAttributeDataObject(this.container, TUSCANYPackage.eINSTANCE.getWidgetImplementation_Location());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginRight = 5;
        implComp.setLayout((Layout)layout);
        this.mainSection = new EMFSection(toolkit);
        this.mainSection.setColumns(3);
        this.addText(this.mainSection, Messages.WidgetImplPropertiesSectionAreaExtender_0);
        this.mainSection.createControls(implComp);
        toolkit.paintBordersFor(implComp);
    }

    private void addText(EMFSection section, String fieldName) {
        section.addWidget((ControlWidget)new TextFieldWithBrowse(new String[]{fieldName}, (DataObject)this.data));
    }

    public void dispose() {
        EventTimer.releaseTimer();
    }

    public void refresh() {
        this.container.setParentObject((Object)this.impl, true);
        this.mainSection.populateControls();
    }

    public void setInput(Object input) {
        if (input instanceof Implementation) {
            this.impl = (Implementation)input;
        }
    }

    private class TextFieldWithBrowse
    extends TextFieldsWithBrowseControlWidget {
        public TextFieldWithBrowse(String[] names, DataObject data) {
            super(names, data, WidgetImplPropertiesSectionAreaExtender.this.timer);
        }

        protected String combine(String[] values) {
            return values[0];
        }

        protected void handleBrowseButton() {
            HashMap<String, IProject> dataMap = new HashMap<String, IProject>();
            IEditorPart part = ScaUtil.getActiveEditor();
            Shell shell = part.getSite().getShell();
            IProject project = ScaUtil.getIFile().getProject();
            WidgetSelectionDialogFactory factory = new WidgetSelectionDialogFactory();
            dataMap.put("CURRENT_RESOURCE", project);
            ISelectionDialog dialog = factory.createSelectionDialog(shell, dataMap);
            if (dialog.open() == 0) {
                String selection = dialog.getDataBean().serialize();
                this.setText(new String[]{selection});
            }
        }

        protected String[] split(String value) {
            return new String[]{value};
        }
    }
}

