/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.widget.impl.ui;

import com.ibm.ccl.sca.composite.emf.widget.impl.WidgetImpl;
import com.ibm.ccl.sca.composite.emf.widget.impl.ui.ResourceContentProvider;
import com.ibm.ccl.sca.composite.emf.widget.impl.ui.ResourceLabelProvider;
import com.ibm.ccl.sca.composite.emf.widget.impl.ui.WidgetUtil;
import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import com.ibm.ccl.sca.ui.messages.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ResourceSelectionDialog
extends TitleAreaDialog
implements ISelectionDialog {
    private IProject project;
    private String title;
    private String message;
    private TreeViewer treeViewer;
    private IPath selection;

    public ResourceSelectionDialog(Shell shell, IProject project, String title, String message) {
        super(shell);
        this.project = project;
        this.title = title;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ResourceSelectionDialog_0);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite child = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        child.setLayout((Layout)layout);
        child.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(child, 2052);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new ResourceContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ResourceLabelProvider());
        this.treeViewer.setInput((Object)new IProject[]{this.project});
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ResourceSelectionDialog.this.handleSelectionChanged();
            }
        });
        Composite buttonComposite = new Composite(child, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        Button expandAll = new Button(buttonComposite, 8);
        Button collapseAll = new Button(buttonComposite, 8);
        expandAll.setText(Messages.SCA_EXPAND_ALL_BUTTON_TEXT);
        collapseAll.setText(Messages.SCA_COLLAPSE_ALL_BUTTON_TEXT);
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelectionDialog.this.treeViewer.expandAll();
            }
        });
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelectionDialog.this.treeViewer.collapseAll();
            }
        });
        return child;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOk(false);
        return control;
    }

    private void handleSelectionChanged() {
        IResource selectedResource = (IResource)((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        this.enableOk(selectedResource instanceof IFile);
    }

    protected void okPressed() {
        IResource selectedResource = (IResource)((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        IPath path = selectedResource.getFullPath();
        IPath rootPath = WidgetUtil.getWebContentPath(selectedResource.getProject());
        this.selection = path.removeFirstSegments(rootPath.segmentCount());
        super.okPressed();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    private void enableOk(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public IDataBean getDataBean() {
        WidgetImpl widgetImpl = new WidgetImpl();
        widgetImpl.setPath(this.selection);
        return widgetImpl;
    }
}

