/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.widget.impl.ui;

import com.ibm.ccl.sca.composite.emf.widget.impl.ui.WidgetUtil;
import com.ibm.ccl.sca.ui.plugin.SCAToolsUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ResourceContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        Object[] result = new Object[]{};
        if (parentElement instanceof IProject[]) {
            result = (Object[])parentElement;
        }
        if (parentElement instanceof IContainer) {
            IContainer container = (IContainer)parentElement;
            int containerIndex = ResourceContentProvider.getContainerIndex(container);
            IPath rootPath = WidgetUtil.getWebContentPath(container.getProject());
            try {
                if (rootPath.segmentCount() == containerIndex + 1) {
                    result = container.members();
                } else if (containerIndex != -1) {
                    IResource resource = container.findMember(rootPath.segment(containerIndex + 1));
                    result = new Object[]{resource};
                }
            }
            catch (CoreException exc) {
                SCAToolsUIPlugin.traceError((Exception)((Object)exc));
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static int getContainerIndex(IContainer container) {
        int result = -1;
        IPath rootPath = WidgetUtil.getWebContentPath(container.getProject());
        IPath path = container.getFullPath();
        String[] rootSegs = rootPath.segments();
        String[] pathSegs = path.segments();
        int index = 0;
        while (index < pathSegs.length) {
            if (!pathSegs[index].equals(rootSegs[index])) break;
            if (index == rootSegs.length - 1) {
                result = index;
                break;
            }
            if (index == pathSegs.length - 1) {
                result = index;
            }
            ++index;
        }
        return result;
    }
}

