/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.widget.impl.tuscany;

import com.ibm.ccl.sca.composite.emf.widget.impl.Messages;
import com.ibm.ccl.sca.composite.emf.widget.impl.WidgetActivator;
import com.ibm.ccl.sca.core.model.ISCAArtifact;
import com.ibm.ccl.sca.core.model.ISCAArtifactResolver;
import com.ibm.ccl.sca.core.model.SCAModelResolver;
import com.ibm.ccl.sca.core.tracing.SCATrace;
import com.ibm.ccl.sca.internal.core.model.base.SCAArtifact;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.implementation.widget.WidgetImplementation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;

public class WidgetImplementationResolver
implements ISCAArtifactResolver {
    private static final String TYPE_ID = "com.ibm.ccl.sca.web20.implementation.widget";
    private static final String TRACE_COMPONENT = "model/resolver/widget";
    private IProject parentProject;
    List<IPath> resolvedPaths = new ArrayList<IPath>();
    IStatus status = null;

    public WidgetImplementationResolver(ISCAArtifact<?> context) {
        this.parentProject = context.getParent();
    }

    private void searchProject(List<ISCAArtifact<?>> artifacts, IProject project, IPath path, IProgressMonitor monitor) {
        if (!JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFile file = component.getRootFolder().getFile(path);
        IResource resource = file.getUnderlyingResource();
        if (resource == null || !resource.exists() || resource.getType() != 1) {
            return;
        }
        SCAArtifact<IResource> artifact = new SCAArtifact<IResource>(project, resource){

            protected IResource getInternalModel() throws CoreException {
                return this.getResource();
            }
        };
        artifacts.add((ISCAArtifact<?>)artifact);
    }

    public List<? extends ISCAArtifact<?>> resolve(Object modelObject, IProgressMonitor monitor) throws CoreException {
        SCAModelResolver.ResolutionStatus resolutionStatus;
        IProject[] referencedProjects;
        this.status = Status.OK_STATUS;
        ArrayList artifacts = new ArrayList();
        String location = ((WidgetImplementation)modelObject).getLocation();
        if (location == null || (location = location.trim()).length() == 0) {
            return artifacts;
        }
        Path path = new Path(location);
        if (this.resolvedPaths.contains(path)) {
            return artifacts;
        }
        SCATrace.trace((Plugin)WidgetActivator.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Resolving path: " + path));
        SCATrace.trace((Plugin)WidgetActivator.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Searching parent project: " + this.parentProject));
        this.searchProject(artifacts, this.parentProject, (IPath)path, monitor);
        IProject[] iProjectArray = referencedProjects = this.parentProject.getReferencedProjects();
        int n = referencedProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            SCATrace.trace((Plugin)WidgetActivator.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("Searching referenced project: " + project));
            this.searchProject(artifacts, project, (IPath)path, monitor);
            ++n2;
        }
        this.resolvedPaths.add((IPath)path);
        if (artifacts.size() == 0) {
            resolutionStatus = new SCAModelResolver.ResolutionStatus(4, Messages.bind((String)Messages.ERR_UNRESOLVED_LOCATION, (Object)location), (Object)location);
            resolutionStatus.setType(TYPE_ID);
            this.status = resolutionStatus;
        } else if (artifacts.size() > 1) {
            resolutionStatus = new SCAModelResolver.ResolutionStatus(2, Messages.bind((String)Messages.WARN_MULTIPLE_RESOLVED_LOCATION, (Object)location), (Object)location);
            resolutionStatus.setType(TYPE_ID);
            this.status = resolutionStatus;
        }
        SCATrace.trace((Plugin)WidgetActivator.getDefault(), (String)TRACE_COMPONENT, (int)2, (String)("HTML resources found: " + artifacts.size()));
        return artifacts;
    }

    public List<? extends ISCAArtifact<?>> resolve(QName qname, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IStatus getStatus() {
        return this.status;
    }
}

