/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.widget.impl.datamodel;

import com.ibm.ccl.sca.composite.emf.widget.impl.Messages;
import com.ibm.etools.webedit.common.commands.InsertHeadObjectCommand;
import com.ibm.etools.webedit.common.commands.utils.HeadElementModifier;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webtools.webpage.core.IDocumentEditor;
import java.util.List;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.w3c.dom.Element;

public class WidgetImplDocumentEditor
implements IDocumentEditor {
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SRC = "src";
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String REFERENCE = "Reference";
    private static final String PROPERTY = "Property";
    private static final String GET_RESPONSE = "_getResponse";
    private static final String X_RESPONSE = "_xResponse";
    private String componentName;
    private String prefix;
    private List<String> atomReferences;
    private List<String> httpReferences;
    private List<String> references;
    private List<String> properties;
    private boolean hasAtomBinding;
    private boolean hasHttpBinding;

    public boolean shouldRun(IDataModel pageModel) {
        this.componentName = (String)pageModel.getProperty("ISCADataModelProperties.COMPONENT_NAME");
        if (this.componentName == null) {
            return false;
        }
        this.prefix = pageModel.getStringProperty("IWebPageDataModelProperties.FILE_PREFIX");
        this.atomReferences = (List)pageModel.getProperty("ISCADataModelProperties.ATOM_REFERENCES");
        this.httpReferences = (List)pageModel.getProperty("ISCADataModelProperties.HTTP_REFERENCES");
        this.references = (List)pageModel.getProperty("ISCADataModelProperties.REFERENCES");
        this.properties = (List)pageModel.getProperty("ISCADataModelProperties.PROPERTIES");
        this.hasAtomBinding = !this.atomReferences.isEmpty();
        this.hasHttpBinding = !this.httpReferences.isEmpty();
        return true;
    }

    private Element insertScript(HTMLEditDomain editDomain, String contents) {
        InsertHeadObjectCommand command = new InsertHeadObjectCommand();
        command.setCommandTarget((HTMLCommandTarget)editDomain);
        HeadElementModifier.ScriptFilter filter = command.getScriptFilter(contents);
        command.setElementFilter((HeadElementModifier.ElementFilter)filter);
        if (!command.canExecute()) {
            return null;
        }
        command.execute();
        Element element = filter.getElement();
        if (element == null) {
            return null;
        }
        element.removeAttribute(ATTR_LANGUAGE);
        element.setAttribute(ATTR_TYPE, TEXT_JAVASCRIPT);
        return element;
    }

    private Element insertSrcScript(HTMLEditDomain editDomain) {
        Element element = this.insertScript(editDomain, "");
        if (element == null) {
            return null;
        }
        element.setAttribute(ATTR_SRC, String.valueOf('/') + this.componentName + '/' + this.prefix + ".js");
        return element;
    }

    private String getSetupScript() {
        StringBuffer buffer = new StringBuffer("\n");
        buffer.append("\tdojo.registerModulePath(\"tuscany\", \"/").append(this.componentName).append("/tuscany\");\n");
        if (this.hasAtomBinding || !this.hasHttpBinding) {
            buffer.append("\tdojo.require(\"tuscany.AtomService\");\n");
        }
        if (this.hasHttpBinding || !this.hasAtomBinding) {
            buffer.append("\tdojo.require(\"dojo.rpc.JsonService\");\n");
        }
        return buffer.toString();
    }

    private void genVarScript(StringBuffer buffer, String name, String type) {
        buffer.append("\t\t//@").append(type).append("\n");
        buffer.append("\t\tvar ").append(name).append(" = new tuscany.sca.").append(type).append("(\"").append(name).append("\");\n\n");
    }

    private void genAtomCallbackStub(StringBuffer buffer, String name) {
        buffer.append("\t\tvar ").append(name).append(GET_RESPONSE).append(" = function(feed) {\n");
        buffer.append("\t\t\t// ").append(Messages.TEXT_STUB_COMMENT).append("\n");
        buffer.append("\t\t};\n\n");
    }

    private void genHttpCallbackStub(StringBuffer buffer, String name) {
        buffer.append("\t\tvar ").append(name).append(X_RESPONSE).append(" = function(payload, exception) {\n");
        buffer.append("\t\t\tif (exception) {\n");
        buffer.append("\t\t\t\talert(exception.message);\n");
        buffer.append("\t\t\t\treturn;\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t\t// ").append(Messages.TEXT_STUB_COMMENT).append("\n");
        buffer.append("\t\t};\n\n");
    }

    private void genInitScript(StringBuffer buffer) {
        for (String name : this.atomReferences) {
            buffer.append("\t\t").append(name).append(".get(\"\").addCallback(").append(name).append(GET_RESPONSE).append(");\n");
        }
        boolean hasPrevious = !this.atomReferences.isEmpty();
        for (String name : this.httpReferences) {
            if (hasPrevious) {
                buffer.append("\n");
            }
            buffer.append("\t\t// ").append(Messages.TEXT_HTTP_COMMENT).append("\n");
            buffer.append("\t\t// ").append(name).append(".x().addCallback(").append(name).append(X_RESPONSE).append(");\n");
            hasPrevious = true;
        }
    }

    public boolean editDocument(HTMLEditDomain editDomain) {
        if (this.insertScript(editDomain, this.getSetupScript()) == null) {
            return false;
        }
        if (this.insertSrcScript(editDomain) == null) {
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        for (String name : this.atomReferences) {
            this.genVarScript(buffer, name, REFERENCE);
        }
        for (String name : this.httpReferences) {
            this.genVarScript(buffer, name, REFERENCE);
        }
        for (String name : this.references) {
            this.genVarScript(buffer, name, REFERENCE);
        }
        for (String name : this.properties) {
            this.genVarScript(buffer, name, PROPERTY);
        }
        for (String name : this.atomReferences) {
            this.genAtomCallbackStub(buffer, name);
        }
        for (String name : this.httpReferences) {
            this.genHttpCallbackStub(buffer, name);
        }
        if (this.hasAtomBinding || this.hasHttpBinding) {
            this.genInitScript(buffer);
        }
        if (buffer.length() > 0) {
            buffer.append("\n\t\t// ").append(Messages.TEXT_DOJO_CONNECT_COMMENT).append("\n");
            buffer.append("\t};\n\n");
            if (this.insertScript(editDomain, "\n\n\tdojo.addOnLoad(function() {\n\n" + buffer.toString()) == null) {
                return false;
            }
        }
        return true;
    }
}

