/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.web;

import com.ibm.ccl.sca.core.util.PlatformUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.application.Web;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WebUtil {
    public static List<IProject> getJEE_WebProjectsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (WebUtil.isWebProj(project)) {
                result.add(project);
            }
            ++n2;
        }
        return result;
    }

    public static IProject getProjectFromEObject(EObject rootObject) {
        Path rootPath = new Path(rootObject.eResource().getURI().toString());
        return PlatformUtil.getProjectFromResourcePath((IPath)rootPath);
    }

    public static List<IProject> getProjectsFromWarNames(List<String> projectWarNames) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (String projectName : projectWarNames) {
            IProject project;
            if (projectName.endsWith(".war")) {
                projectName = projectName.substring(0, projectName.length() - 4);
            }
            if (!(project = root.getProject(projectName)).exists() || !WebUtil.isWebProj(project)) continue;
            projects.add(project);
        }
        return projects;
    }

    public static List<String> getWebProjsInEar(IProject earProj) {
        ArrayList<String> result = new ArrayList<String>();
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)earProj);
        Object modelObject = provider.getModelObject();
        Application appEar = (Application)modelObject;
        List modules = appEar.getModules();
        for (Module module : modules) {
            Web web = module.getWeb();
            if (web == null) continue;
            result.add(web.getWebUri());
        }
        return result;
    }

    public static boolean isWebProj(IProject project) {
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        return projectComp != null && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)projectComp) && JavaEEProjectUtilities.isDynamicWebProject((IProject)project);
    }

    public static boolean isAppProj(IProject project) {
        IVirtualComponent projectComp = ComponentCore.createComponent((IProject)project);
        return projectComp != null && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)projectComp) && JavaEEProjectUtilities.isEARProject((IProject)project);
    }

    public static String[] getWebProjectNames(IProject rootProject) {
        String[] names = null;
        if (WebUtil.isAppProj(rootProject)) {
            names = WebUtil.getWebProjsInEar(rootProject).toArray(new String[0]);
        } else if (WebUtil.isWebProj(rootProject)) {
            names = new String[]{rootProject.getName()};
        }
        int index = 0;
        while (index < names.length) {
            if (names[index].endsWith(".war")) {
                names[index] = names[index].substring(0, names[index].length() - 4);
            }
            ++index;
        }
        return names;
    }
}

