/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.emf.web.impl.selection;

import com.ibm.ccl.sca.composite.emf.web.impl.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.web.WebUtil;
import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.core.bean.NullObject;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class WebSelectionDialog
extends TitleAreaDialog
implements ISelectionDialog {
    private String selection;
    private IProject project;
    private List webList;

    public WebSelectionDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.WebSelectionDialog_0);
    }

    protected Point getInitialSize() {
        return new Point(350, 250);
    }

    protected Control createDialogArea(Composite parent) {
        String[] webNames;
        this.setTitle(Messages.WebSelectionDialog_1);
        this.setMessage(Messages.bind((String)Messages.WebSelectionDialog_2, (Object)this.project.getName()));
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite child = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        child.setLayout((Layout)layout);
        child.setLayoutData((Object)new GridData(1808));
        this.webList = new List(child, 2052);
        GridData data = new GridData(1808);
        this.webList.setLayoutData((Object)data);
        this.webList.setFont(parent.getFont());
        this.webList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebSelectionDialog.this.handleSelectionChanged();
            }
        });
        String[] stringArray = webNames = WebUtil.getWebProjectNames(this.project);
        int n = webNames.length;
        int n2 = 0;
        while (n2 < n) {
            String webName = stringArray[n2];
            this.webList.add(webName);
            ++n2;
        }
        return child;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOk(false);
        return control;
    }

    private void handleSelectionChanged() {
        this.enableOk(this.webList.getSelectionCount() == 1);
    }

    protected void okPressed() {
        this.selection = this.webList.getSelection()[0];
        super.okPressed();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    private void enableOk(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public String getSelection() {
        if (!this.selection.endsWith(".war")) {
            this.selection = String.valueOf(this.selection) + ".war";
        }
        return this.selection;
    }

    public IDataBean getDataBean() {
        NullObject dataBean = new NullObject(){

            public String getID() {
                return "implementation.web";
            }

            public String serialize() {
                return WebSelectionDialog.this.getSelection();
            }

            public Object getProperty(String key) {
                return WebSelectionDialog.this.getSelection();
            }
        };
        return dataBean;
    }
}

