/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.preferences;

import com.ibm.ccl.sca.composite.emf.spring.impl.Messages;
import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.core.preferences.PreferencesState;
import com.ibm.ccl.sca.core.util.StatusUtil;
import com.ibm.ccl.sca.ui.util.EventTimer;
import com.ibm.ccl.sca.ui.util.UIUtils;
import com.ibm.ws.ast.st.core.WASRuntimeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public class SpringPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String INFOPOP_SPRING_PREFERENCES = "SPRING_PREFERENCES";
    public static final String SPRING_TYPE = "com.ibm.ccl.sca.composite.emf.spring.impl.springType";
    public static final String SPRING_DISTRO = "com.ibm.ccl.sca.composite.emf.spring.impl.springDistro";
    public static final String SPRING_LOCATION = "com.ibm.ccl.sca.composite.emf.spring.impl.springLocation";
    private static final String TYPE_DISTRO = "distro";
    private static final String TYPE_JAR = "jar";
    private static final String SPRING_BEANS = "dist/modules/spring-beans.jar";
    private static final String SPRING_CONTEXT = "dist/modules/spring-context.jar";
    private static final String SPRING_CORE = "dist/modules/spring-core.jar";
    private static final String JAR_NAME = "SpringSharedLibAsset.jar";
    private PreferencesState preferences = new PreferencesState("com.ibm.ccl.sca.composite.emf.spring.impl");
    private Button distroRadio;
    private Label distroLocationLabel;
    private Text distroLocation;
    private Button distroBrowse;
    private Label distroAssetLabel;
    private Text distroAsset;
    private Button jarRadio;
    private Label jarLocationLabel;
    private Text jarLocation;
    private Button jarBrowse;
    private File springRuntime;
    private File springBeans;
    private File springContext;
    private File springCore;
    private File configuredJar = SpringImplActivator.getDefault().getStateLocation().append("SpringSharedLibAsset.jar").toFile();
    private EventTimer timer = EventTimer.acquireTimer();

    public SpringPreferencePage() {
    }

    public SpringPreferencePage(String title) {
        super(title);
    }

    public SpringPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    private void locateRuntimeJar() {
        Pattern pattern = Pattern.compile("SCA-implementation-spring-runtime-.+\\.jar");
        IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
        int n = iRuntimeArray.length;
        int n2 = 0;
        while (n2 < n) {
            File optionalLibraries;
            IRuntime runtime = iRuntimeArray[n2];
            if (WASRuntimeUtil.isWASv70OrLaterRuntime((IRuntime)runtime) && (optionalLibraries = runtime.getLocation().append("feature_packs/sca/optionalLibraries").toFile()).isDirectory()) {
                File[] fileArray = optionalLibraries.listFiles();
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray[n4];
                    if (!file.isDirectory() && pattern.matcher(file.getName()).matches()) {
                        this.springRuntime = file;
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private boolean validateDistro(String location) {
        File distro = new File(location);
        if (!distro.isDirectory()) {
            return false;
        }
        this.springBeans = new File(distro, SPRING_BEANS);
        if (!this.springBeans.isFile()) {
            return false;
        }
        this.springContext = new File(distro, SPRING_CONTEXT);
        if (!this.springContext.isFile()) {
            return false;
        }
        this.springCore = new File(distro, SPRING_CORE);
        return this.springCore.isFile();
    }

    private boolean validateJar(String location) {
        Path path = new Path(location);
        return path.lastSegment().equals(JAR_NAME);
    }

    private void validate(boolean isDistro) {
        if (isDistro) {
            String location = this.distroLocation.getText().trim();
            if (location.length() > 0 && !this.validateDistro(location)) {
                this.setErrorMessage(Messages.ERR_INVALID_SPRING_DISTRO);
                this.setValid(false);
                return;
            }
        } else {
            String location = this.jarLocation.getText().trim();
            if (location.length() > 0 && !this.validateJar(location)) {
                this.setErrorMessage(Messages.bind((String)Messages.ERR_INVALID_SPRING_JAR, (Object)JAR_NAME));
                this.setValid(false);
                return;
            }
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private void changeState(boolean isDistro) {
        this.distroRadio.setSelection(isDistro &= this.springRuntime != null);
        this.distroLocationLabel.setEnabled(isDistro);
        this.distroLocation.setEnabled(isDistro);
        this.distroBrowse.setEnabled(isDistro);
        this.distroAssetLabel.setEnabled(isDistro);
        this.distroAsset.setEnabled(isDistro);
        this.jarRadio.setSelection(!isDistro);
        this.jarLocationLabel.setEnabled(!isDistro);
        this.jarLocation.setEnabled(!isDistro);
        this.jarBrowse.setEnabled(!isDistro);
        this.validate(isDistro);
    }

    private void init() {
        String type = this.preferences.getValue(SPRING_TYPE, TYPE_DISTRO, null);
        if (TYPE_DISTRO.equals(type)) {
            this.distroLocation.setText(this.preferences.getValue(SPRING_DISTRO, "", null));
            this.distroAsset.setText(this.preferences.getValue(SPRING_LOCATION, "", null));
            this.changeState(true);
        } else {
            this.jarLocation.setText(this.preferences.getValue(SPRING_LOCATION, "", null));
            this.changeState(false);
        }
    }

    protected Control createContents(Composite parent) {
        UIUtils utils = new UIUtils("com.ibm.ccl.sca.composite.emf.spring.impl");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ccl.sca.composite.emf.spring.impl.SPRING_PREFERENCES");
        this.locateRuntimeJar();
        if (this.springRuntime == null) {
            Composite msgComposite = utils.createComposite(parent, 1, 5, 0);
            Text text = utils.createText(msgComposite, null, null, null, 72);
            text.setLayoutData((Object)new GridData(390, -1));
            text.setText(Messages.MSG_DISTRO_DISABLED);
            text.setBackground(msgComposite.getBackground());
        }
        Composite composite = utils.createComposite(parent, 3, 3, 3);
        this.distroRadio = utils.createRadioButton(composite, Messages.LABEL_SELECT_SPRING_DISTRO, null, null);
        this.distroRadio.setEnabled(this.springRuntime != null);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.distroRadio.setLayoutData((Object)gd);
        this.distroRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpringPreferencePage.this.changeState(true);
            }
        });
        this.distroLocationLabel = utils.createLabel(composite, Messages.LABEL_LOCATION, null, 0);
        this.distroLocation = utils.createText(composite, null, null, null, 2048);
        gd = new GridData();
        gd.widthHint = 250;
        this.distroLocation.setLayoutData((Object)gd);
        this.distroLocation.addModifyListener((ModifyListener)new DelayedValidator(true));
        this.distroBrowse = utils.createButton(8, composite, Messages.LABEL_BROWSE, null, null);
        this.distroBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(SpringPreferencePage.this.getShell());
                dialog.setText(Messages.LABEL_SELECT);
                String path = dialog.open();
                if (path != null) {
                    SpringPreferencePage.this.distroLocation.setText(path);
                }
            }
        });
        this.distroAssetLabel = utils.createLabel(composite, Messages.LABEL_ASSET, null, 0);
        this.distroAsset = utils.createText(composite, null, null, null, 2048);
        gd = new GridData();
        gd.widthHint = 250;
        this.distroAsset.setLayoutData((Object)gd);
        this.distroAsset.setEditable(false);
        Label spacer = new Label(composite, 0);
        gd = new GridData();
        gd.horizontalSpan = 3;
        spacer.setLayoutData((Object)gd);
        this.jarRadio = utils.createRadioButton(composite, Messages.LABEL_SELECT_SPRING_ASSET, null, null);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.jarRadio.setLayoutData((Object)gd);
        this.jarRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpringPreferencePage.this.changeState(false);
            }
        });
        this.jarLocationLabel = utils.createLabel(composite, Messages.LABEL_LOCATION, null, 0);
        this.jarLocation = utils.createText(composite, null, null, null, 2048);
        gd = new GridData();
        gd.widthHint = 250;
        this.jarLocation.setLayoutData((Object)gd);
        this.jarLocation.addModifyListener((ModifyListener)new DelayedValidator(false));
        this.jarBrowse = utils.createButton(8, composite, Messages.LABEL_BROWSE, null, null);
        this.jarBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SpringPreferencePage.this.getShell());
                dialog.setFilterExtensions(new String[]{SpringPreferencePage.JAR_NAME});
                dialog.setText(Messages.LABEL_SELECT);
                String path = dialog.open();
                if (path != null) {
                    SpringPreferencePage.this.jarLocation.setText(path);
                }
            }
        });
        this.init();
        return composite;
    }

    private void addFile(JarOutputStream jar, File file) throws IOException {
        byte[] buffer = new byte[1024];
        InputStream in = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(file));
            jar.putNextEntry(new JarEntry(file.getName()));
            while ((read = in.read(buffer)) != -1) {
                jar.write(buffer, 0, read);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void handleError(IStatus status) {
        MultiStatus multiStatus = StatusUtil.multiStatus((String)Messages.ERR_ASSEMBLING_JAR, (IStatus[])new IStatus[]{status});
        StatusManager.getManager().handle((IStatus)multiStatus, 4);
    }

    private boolean assembleJar() {
        if (this.configuredJar.exists() && !this.configuredJar.delete()) {
            this.handleError(StatusUtil.errorStatus((String)Messages.bind((String)Messages.ERR_CANNOT_DELETE_JAR, (Object)this.configuredJar)));
            return false;
        }
        ZipOutputStream jar = null;
        try {
            jar = new JarOutputStream(new FileOutputStream(this.configuredJar));
            this.addFile((JarOutputStream)jar, this.springRuntime);
            this.addFile((JarOutputStream)jar, this.springBeans);
            this.addFile((JarOutputStream)jar, this.springContext);
            this.addFile((JarOutputStream)jar, this.springCore);
            return true;
        }
        catch (Exception e) {
            this.handleError(StatusUtil.errorStatus((Throwable)e));
            return false;
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException e) {
                    SpringImplActivator.traceError(e);
                }
            }
        }
    }

    private BuildChoice shouldBuild(String configuredJarLocation) {
        boolean newConfiguredState;
        boolean oldConfiguredState = this.preferences.getValue(SPRING_LOCATION, "", null).length() > 0;
        boolean bl = newConfiguredState = configuredJarLocation.length() > 0;
        if (oldConfiguredState == newConfiguredState) {
            return BuildChoice.No;
        }
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.TITLE_SPRING_SETTINGS_CHANGED, null, Messages.MSG_SPRING_SETTINGS_CHANGED, 3, new String[]{Messages.LABEL_YES, Messages.LABEL_NO, Messages.LABEL_CANCEL}, 2);
        int response = dialog.open();
        if (response == -1) {
            return BuildChoice.Cancel;
        }
        return BuildChoice.values()[response];
    }

    private boolean apply() {
        BuildChoice shouldBuild = BuildChoice.No;
        String configuredJarLocation = "";
        if (this.distroRadio.getSelection()) {
            String newLocation = this.distroLocation.getText().trim();
            if (newLocation.length() == 0) {
                shouldBuild = this.shouldBuild(configuredJarLocation);
                if (BuildChoice.Cancel.equals((Object)shouldBuild)) {
                    return false;
                }
                if (this.configuredJar.exists()) {
                    this.configuredJar.delete();
                }
            } else {
                configuredJarLocation = this.configuredJar.getPath();
                shouldBuild = this.shouldBuild(configuredJarLocation);
                if (BuildChoice.Cancel.equals((Object)shouldBuild)) {
                    return false;
                }
                String origLocation = this.preferences.getValue(SPRING_DISTRO, "", null);
                if (!(this.configuredJar.isFile() && newLocation.equals(origLocation) || this.assembleJar())) {
                    return false;
                }
            }
            this.distroAsset.setText(configuredJarLocation);
            this.preferences.setValue(SPRING_TYPE, TYPE_DISTRO, null);
            this.preferences.setValue(SPRING_DISTRO, newLocation, null);
            this.preferences.setValue(SPRING_LOCATION, configuredJarLocation, null);
        } else {
            configuredJarLocation = this.jarLocation.getText().trim();
            shouldBuild = this.shouldBuild(configuredJarLocation);
            if (BuildChoice.Cancel.equals((Object)shouldBuild)) {
                return false;
            }
            if (this.configuredJar.exists()) {
                this.configuredJar.delete();
            }
            this.preferences.setValue(SPRING_TYPE, TYPE_JAR, null);
            this.preferences.setValue(SPRING_DISTRO, "", null);
            this.preferences.setValue(SPRING_LOCATION, configuredJarLocation, null);
        }
        if (BuildChoice.Yes.equals((Object)shouldBuild)) {
            try {
                ResourcesPlugin.getWorkspace().build(6, null);
            }
            catch (CoreException e) {
                SpringImplActivator.getDefault().getLog().log(e.getStatus());
            }
        }
        return true;
    }

    protected void performApply() {
        this.apply();
    }

    protected void performDefaults() {
        this.distroLocation.setText("");
        this.distroAsset.setText("");
        this.jarLocation.setText("");
        this.init();
        super.performDefaults();
    }

    public boolean performOk() {
        return this.apply() && super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        EventTimer.releaseTimer();
        super.dispose();
    }

    private static enum BuildChoice {
        Yes,
        No,
        Cancel;

    }

    private class DelayedValidator
    implements ModifyListener,
    Runnable {
        private boolean isDistro;

        public DelayedValidator(boolean isDistro) {
            this.isDistro = isDistro;
        }

        public void modifyText(ModifyEvent arg0) {
            SpringPreferencePage.this.timer.add((Runnable)this);
        }

        @Override
        public void run() {
            SpringPreferencePage.this.validate(this.isDistro);
        }
    }
}

