/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection;

import com.ibm.ccl.sca.composite.emf.spring.impl.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringContentProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringLabelProvider;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringSelectable;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringUtils;
import com.ibm.ccl.sca.core.bean.IDataBean;
import com.ibm.ccl.sca.ui.contributions.ISelectionDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class SpringSelectionDialog
extends TitleAreaDialog
implements ISelectionDialog {
    private TreeViewer treeViewer;
    private String selection;
    private IProject project;

    public SpringSelectionDialog(Shell parentShell, IProject project) {
        super(parentShell);
        this.project = project;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.SpringSelectionDialog_0);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.SpringSelectionDialog_1);
        this.setMessage(Messages.SpringSelectionDialog_2);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite child = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        child.setLayout((Layout)layout);
        child.setLayoutData((Object)new GridData(1808));
        Tree tree = new Tree(child, 2052);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        tree.setFont(parent.getFont());
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new SpringContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SpringLabelProvider());
        this.treeViewer.setInput((Object)SpringUtils.getRootSpringProjects(this.project));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SpringSelectionDialog.this.handleSelectionChanged();
            }
        });
        Composite buttonComposite = new Composite(child, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        Button expandAll = new Button(buttonComposite, 8);
        Button collapseAll = new Button(buttonComposite, 8);
        expandAll.setText(Messages.SpringSelectionDialog_3);
        collapseAll.setText(Messages.SpringSelectionDialog_4);
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpringSelectionDialog.this.treeViewer.expandAll();
            }
        });
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpringSelectionDialog.this.treeViewer.collapseAll();
            }
        });
        return child;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.enableOk(false);
        return control;
    }

    private void handleSelectionChanged() {
        SpringSelectable selectedSpring = (SpringSelectable)((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        boolean enableOk = selectedSpring.isValidSelection();
        this.enableOk(enableOk);
    }

    protected void okPressed() {
        SpringSelectable selectedSpring = (SpringSelectable)((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        IPath path = selectedSpring.getSelectedPath();
        this.selection = path.segmentCount() == 1 ? "." : selectedSpring.getSelectedPath().removeFirstSegments(1).toString();
        super.okPressed();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    private void enableOk(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }

    public String getSelection() {
        return this.selection;
    }

    public IDataBean getDataBean() {
        return new SpringBean();
    }

    private class SpringBean
    implements IDataBean {
        private SpringBean() {
        }

        public String getDefaultServiceName() {
            return null;
        }

        public String getID() {
            return null;
        }

        public Object getProperty(String key) {
            return SpringSelectionDialog.this.getSelection();
        }

        public String serialize() {
            return SpringSelectionDialog.this.getSelection();
        }

        public void setProperty(String key, Object value) {
        }
    }
}

