/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection;

import com.ibm.ccl.sca.composite.emf.spring.impl.SpringImplActivator;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.ISpringImplementation;
import com.ibm.ccl.sca.composite.emf.spring.impl.model.SpringImplementationFactory;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringFile;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringSelectable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class SpringFolder
implements SpringSelectable {
    private List<SpringSelectable> children;
    private IContainer folder;
    private boolean isValid;

    public SpringFolder(IContainer folder) {
        this.folder = folder;
        this.isValid = false;
        this.children = new ArrayList<SpringSelectable>();
        this.findSpringChildren();
    }

    private void findSpringChildren() {
        IResource[] resources = null;
        IProject project = this.folder.getProject();
        try {
            IResource[] iResourceArray = resources = this.folder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                IPath path = resource.getFullPath().removeFirstSegments(1);
                if (resource instanceof IFile) {
                    if (this.checkPath(project, path)) {
                        this.children.add(new SpringFile(resource.getFullPath()));
                    }
                } else if (resource instanceof IContainer) {
                    SpringFolder newFolder = new SpringFolder((IContainer)resource);
                    if (newFolder.isValid || newFolder.getChilden().size() > 0) {
                        this.children.add(newFolder);
                    }
                }
                ++n2;
            }
            IPath folderPath = this.folder.getFullPath();
            folderPath = folderPath.segmentCount() == 1 ? new Path("") : folderPath.removeFirstSegments(1);
            this.isValid = this.checkPath(project, folderPath);
        }
        catch (CoreException exc) {
            SpringImplActivator.traceError((Exception)((Object)exc));
        }
    }

    public List<SpringSelectable> getChilden() {
        return this.children;
    }

    @Override
    public boolean isValidSelection() {
        return this.isValid;
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public IPath getSelectedPath() {
        return this.folder.getFullPath();
    }

    private boolean checkPath(IProject project, IPath path) {
        ISpringImplementation impl = SpringImplementationFactory.createSpringImplementation(project, path);
        return impl != null;
    }
}

