/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring;

import com.ibm.ccl.sca.composite.emf.sca.Implementation;
import com.ibm.ccl.sca.composite.emf.sca.SCAPackage;
import com.ibm.ccl.sca.composite.emf.spring.impl.Messages;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.base.controls.IPropertiesSectionAreaExtender;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringSelectionDialog;
import com.ibm.ccl.sca.composite.ui.custom.extensibility.implementation.spring.selection.SpringUtils;
import com.ibm.ccl.sca.composite.ui.custom.util.ScaUtil;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.ControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.EMFSection;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.TextFieldsWithBrowseControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.TextMessageControlWidget;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.DataObject;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFAttributeDataObject;
import com.ibm.ccl.sca.internal.ui.common.controls.emf.data.EMFReferenceContainer;
import com.ibm.ccl.sca.ui.util.EventTimer;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SpringImplPropertiesSectionAreaExtender
implements IPropertiesSectionAreaExtender {
    private EMFSection mainSection;
    private Implementation impl;
    private EventTimer timer = EventTimer.acquireTimer();
    private Shell shell;
    private TextMessageControlWidget errorWidget;
    private EMFReferenceContainer container;
    private EMFAttributeDataObject data;

    public void createExtendedControls(FormToolkit toolkit, Composite implComp) {
        this.container = new EMFReferenceContainer(null, null, ScaUtil.getResourceEditDomain());
        this.data = new EMFAttributeDataObject(this.container, SCAPackage.eINSTANCE.getSpringImplementation_Location());
        this.data.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SpringImplPropertiesSectionAreaExtender.this.handleTextChanged();
            }
        });
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginRight = 5;
        implComp.setLayout((Layout)layout);
        this.shell = implComp.getShell();
        this.mainSection = new EMFSection(toolkit);
        this.mainSection.setColumns(3);
        this.addText(this.mainSection, Messages.SpringImplPropertiesSectionAreaExtender_0);
        this.errorWidget = new TextMessageControlWidget();
        this.mainSection.addWidget((ControlWidget)this.errorWidget);
        this.mainSection.createControls(implComp);
        toolkit.paintBordersFor(implComp);
    }

    private void handleTextChanged() {
        String newLocation = this.data.getData();
        IProject project = ScaUtil.getIFile().getProject();
        if (SpringUtils.checkPath(project, newLocation)) {
            this.errorWidget.setText(" ");
        } else {
            this.errorWidget.setText(Messages.SpringImplPropertiesSectionAreaExtender_1);
        }
    }

    private void addText(EMFSection section, String fieldName) {
        section.addWidget((ControlWidget)new TextFieldWithBrowse(new String[]{fieldName}, (DataObject)this.data));
    }

    public void dispose() {
        EventTimer.releaseTimer();
    }

    public void refresh() {
        this.container.setParentObject((Object)this.impl, true);
        this.mainSection.populateControls();
        this.handleTextChanged();
    }

    public void setInput(Object input) {
        if (input instanceof Implementation) {
            this.impl = (Implementation)input;
        }
    }

    private class TextFieldWithBrowse
    extends TextFieldsWithBrowseControlWidget {
        public TextFieldWithBrowse(String[] names, DataObject data) {
            super(names, data, SpringImplPropertiesSectionAreaExtender.this.timer);
        }

        protected String combine(String[] values) {
            return values[0];
        }

        protected void handleBrowseButton() {
            IProject project = ScaUtil.getIFile().getProject();
            SpringSelectionDialog dialog = new SpringSelectionDialog(SpringImplPropertiesSectionAreaExtender.this.shell, project);
            if (dialog.open() == 0) {
                String selection = dialog.getSelection();
                this.setText(new String[]{selection});
            }
        }

        protected String[] split(String value) {
            return new String[]{value};
        }
    }
}

